/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.webutilities

import org.apache.http.client.methods.HttpUriRequest
import org.apache.http.client.methods.RequestBuilder
import org.apache.http.entity.StringEntity
import org.apache.http.entity.FileEntity

/**
 * Creates an HTTP request object which represent a HTTP request message.
 *
 * @param   url         Accepts any URL as defined in RFC 2396 and RFC 2732.
 * @param   headers     Accepts any list.
 * @param   method      Accepts any String.
 * @param   body        Accepts any String.
 * @return              A HttpRequestEntity
 */
public static HttpUriRequest createHTTPRequest (String url, Map headers, String method, String body) {

    RequestBuilder httpRequestEntity = new RequestBuilder().create(method)
    httpRequestEntity.setUri(url)
    for (header in headers) {
        String key = header.getKey().toString()
        String value = header.getValue().toString()
        httpRequestEntity.setHeader(key, value)
    }
    httpRequestEntity.setEntity(new StringEntity(body))

    return httpRequestEntity.build()
}

/**
 * Creates an HTTP request object which represent a HTTP request with a zip file in the content
 *
 * @param   url         Accepts any URL as defined in RFC 2396 and RFC 2732.
 * @param   headers     Accepts any list.
 * @param   method      Accepts any String.
 * @param   file              Accepts a File
 * @return              A HttpRequestEntity
 */
public static HttpUriRequest createHTTPRequestForZip (String url, Map headers, String method, File file) {

    RequestBuilder httpRequestEntity = new RequestBuilder().create(method)
    httpRequestEntity.setUri(url)
    for (header in headers) {
        String key = header.getKey().toString()
        String value = header.getValue().toString()
        httpRequestEntity.setHeader(key, value)
    }
    httpRequestEntity.setEntity(new FileEntity(file,"application/zip"))

    return httpRequestEntity.build()
}
