/*
* Licensed Materials - Property of IBM* and/or HCL**
* UrbanCode Deploy
* (c) Copyright IBM Corporation 2013, 2017. All Rights Reserved.
* (c) Copyright HCL Technologies Ltd. 2018. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*
* * Trademark of International Business Machines
* ** Trademark of HCL Technologies Limited
*/
package com.urbancode.air.plugin.webutilities

import org.apache.http.client.methods.CloseableHttpResponse
import org.apache.http.util.EntityUtils

/**
 * Defines the default response property
 *
 * @param   response    Accepts any response entity.
 * @param   outFile     The java File object to use for the output.
 * @param   outputProps Output properties hashmap.
 * @return              A hashmap of the outputs.
 */
public static Map hTTPResponseProcessing(CloseableHttpResponse response, File outFile, Properties outputProps) {
    outputProps['responseStatus'] = response.getStatusLine().getStatusCode().toString()
    response.getAllHeaders().each { header ->
        outputProps[header.name] = header.value.toString()
    }
    if(response.getEntity()) {
        String text = EntityUtils.toString(response.getEntity())
        if (text) {
            if (outFile) {
                outFile.write(text)
            }
            outputProps["responseBody"] = text
        }
    }
    else {
        outputProps["responseBody"] = ""
    }
    return outputProps
}
