/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import com.urbancode.commons.util.Check;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.log4j.Logger;

class SharedConnectionCleaner
extends Thread {
    private static final Logger log = Logger.getLogger(SharedConnectionCleaner.class);
    private static SharedConnectionCleaner sharedInstance;
    private final ConcurrentLinkedQueue<ClientRef> clientRefs = new ConcurrentLinkedQueue();

    static synchronized void track(Object client, long idleConnectionTimeout) {
        if (sharedInstance == null) {
            sharedInstance = new SharedConnectionCleaner();
            sharedInstance.start();
        }
        sharedInstance.track0(client, idleConnectionTimeout);
    }

    SharedConnectionCleaner() {
        this.setName("Idle connection cleaner [shared]");
        this.setDaemon(true);
    }

    public void run() {
        try {
            block4: while (true) {
                Thread.sleep(10000L);
                Iterator<ClientRef> itr = this.clientRefs.iterator();
                while (true) {
                    if (!itr.hasNext()) continue block4;
                    ClientRef ref = itr.next();
                    Object client = ref.get();
                    if (client == null) {
                        itr.remove();
                        continue;
                    }
                    try {
                        ClientConnectionManager mgr;
                        if (client instanceof CloseableHttpClient) {
                            mgr = ((CloseableHttpClient)client).getConnectionManager();
                        } else if (client instanceof DefaultHttpClient) {
                            mgr = ((DefaultHttpClient)client).getConnectionManager();
                        } else {
                            log.error((Object)("Unsupported client type: " + client.getClass().getName()));
                            itr.remove();
                            continue;
                        }
                        if (mgr == null) continue;
                        mgr.closeIdleConnections(ref.idleConnectionTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (Exception e) {
                        log.error((Object)"Error in cleaner thread", (Throwable)e);
                        itr.remove();
                    }
                }
                break;
            }
        }
        catch (InterruptedException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Terminated by interrupt", (Throwable)e);
            }
            return;
        }
    }

    private void track0(Object client, long idleConnectionTimeout) {
        this.clientRefs.add(new ClientRef(client, idleConnectionTimeout));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ClientRef
    extends WeakReference<Object> {
        final long idleConnectionTimeout;

        ClientRef(Object client, long idleConnectionTimeout) {
            super(Check.nonNull((Object)client));
            if (!(client instanceof DefaultHttpClient) && !(client instanceof CloseableHttpClient)) {
                throw new IllegalArgumentException("client is unsupported type: " + client.getClass().getName());
            }
            if (idleConnectionTimeout < 0L) {
                idleConnectionTimeout = 30000L;
            }
            this.idleConnectionTimeout = idleConnectionTimeout;
        }
    }
}

