/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2013. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;

import com.urbancode.commons.util.ssl.OpenX509TrustManager;

import com.urbancode.air.AirPluginTool
import groovyx.net.http.RESTClient
import groovyx.net.http.AuthConfig
import groovyx.net.http.ContentType
import javax.net.ssl.HostnameVerifier
import javax.net.ssl.HttpsURLConnection
import javax.net.ssl.SSLContext
import javax.net.ssl.TrustManager
import javax.net.ssl.X509TrustManager
import org.apache.http.conn.ssl.SSLSocketFactory
import org.apache.http.conn.scheme.Scheme

def apTool = new AirPluginTool(this.args[0], this.args[1])
props = apTool.getStepProperties()
final def workDir = new File('.').canonicalFile
def url = props['url']
def method = props['method']
def headers = props['headers']
def body = props['data']
def contentType = props['contentType']
def untrustedSSL = Boolean.valueOf(props['untrustedSSL'])
def username = props['username']
def password = props['password']
def outFileName = props['outFile']
def outFile
if (outFileName) {
    outFile = new File(outFileName)
    if (!outFile.isAbsolute()) {
        outFile = new File(workDir, outFileName)
    }
}

if (body) {
    def inFile = new File(body)
    if (!inFile.absolute) {
        inFile = new File(workDir, body)
    }
    if (inFile.exists() && !inFile.directory) {
        println "Reading body from file."
        body = inFile.getText()
        println body
    }
}
def requestContentType
switch (contentType) {
    case "ANY":
        requestContentType = groovyx.net.http.ContentType.ANY
        break
    case "TEXT":
        requestContentType = groovyx.net.http.ContentType.TEXT
        break
    case "URLENC":
        requestContentType = groovyx.net.http.ContentType.URLENC
        break
    case "XML":
        requestContentType = groovyx.net.http.ContentType.XML
        break
    case "JSON":
        requestContentType = groovyx.net.http.ContentType.JSON
        break
    case "HTML":
        requestContentType = groovyx.net.http.ContentType.HTML
        break
}

RESTClient client = new RESTClient(url, requestContentType)
//this forces the response reader type to InputStream
client.parser.'application/xml' = client.parser.'text/plain'
client.parser.'application/xhtml+xml' = client.parser.'text/plain'
client.parser.'application/atom+xml' = client.parser.'text/plain'
client.parser.'application/json' = client.parser.'text/plain'
client.parser.'text/html' = client.parser.'text/plain'
client.parser.'application/x-www-form-urlencoded' = client.parser.'text/plain'

//if allowing untrusted SSL, override the Trust Manager interface
if (untrustedSSL) {
    SSLContext sslContext;
    try {
        sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, [(TrustManager) new OpenX509TrustManager()] as TrustManager[], null);
    }
    catch (KeyManagementException e) {
        // can't happen
        throw new RuntimeException(e);
    }
    catch (NoSuchAlgorithmException e) {
        // can't happen
        throw new RuntimeException(e);
    }
    javax.net.ssl.SSLSocketFactory factory = sslContext.getSocketFactory();
    SchemeSocketFactory schemeSocketFactory = new SSLSocketFactory(factory, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
    Scheme scheme = new Scheme("https",  443, schemeSocketFactory);
    client.client.connectionManager.schemeRegistry.register(scheme)
}

def defaultResponse(response, reader, outFile, apTool) {
    println "\nResponse returned status: ${response.getStatus()} ${response.getStatusLine().getReasonPhrase()}"
    apTool.setOutputProperty("responseStatus", "${response.getStatus()}")
    println "Printing Headers:\n"
    response.headers.each { header ->
        apTool.setOutputProperty(header.name, header.value)
        println "${header.name}: ${header.value}"
    }

    if (reader != null) {
        println "Response content type: ${response.getContentType()}\n"
        def text = reader.text
        if (outFile) {
            outFile.write(text)
            println "Response body written to file ${outFile.getAbsolutePath()}"
        }
        else {
            println text
        }
        apTool.setOutputProperty("responseBody", text)
    }
    apTool.setOutputProperties()
}

client.handler.success = { resp, reader ->
    defaultResponse(resp, reader, outFile, apTool)
}
client.handler.failure = { resp, reader ->
    defaultResponse(resp, reader, outFile, apTool)
    throw new Exception("HTTP call failed. Status code: ${resp.getStatus()}")
}

def headerMap = [:]
if (headers) {
    def headerLines = headers.split("\n");

    for (headerLine in headerLines) {
        def firstColonIndex = headerLine.indexOf(':')
        def headerName = headerLine.substring(0, firstColonIndex)
        def headerValue = headerLine.substring(firstColonIndex+1).trim()
        headerMap[headerName] = headerValue
    }
}

if (username && password) {
    println "Authenticating with basic authentication."
    auth = new AuthConfig(client)
    auth.basic(username, password)
    client.setAuthConfig(auth)
}

def response
println "Calling URL: ${url}"
println "Method: ${method}"

switch (method) {
    case "GET":
        response = client.get("headers":headerMap)
        break
    case "POST":
        response = client.post("headers":headerMap, "body":body)
        break
    case "PUT":
        response = client.put("headers":headerMap, "body":body)
        break
    case "DELETE":
        response = client.delete("headers":headerMap)
        break
    case "HEAD":
        response = client.head("headers":headerMap)
        break
    case "DELETE":
        response = client.options("headers":headerMap)
        break
}