/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2002, 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/
package com.urbancode.air.plugin.webutilities

/**
 * [WSP] *CHAR [WSP] ':' / '=' [WSP] *CHAR [WSP] parsed onto blank or given hashmap
 *
 * @param   textArea     Accepts any [WSP] *CHAR [WSP] ':' / '=' [WSP] *CHAR [WSP]
 * @param   happy        Accepts any linked hashmap
 * @return               A linked hashmap built ontop of the linked hashmap happy from parsing the textAeaasss
 */
def static textAreaToHashMap (textArea, def happy = [:]) {
    try {
        textArea.eachLine { text ->
            def mappy = text.split('=|:', 2)
            if (mappy[0].trim()) {
                happy[mappy[0].trim().toLowerCase()] = mappy[1].trim().toLowerCase()
            }
        }
        return happy
    } catch (NullPointerException e) {
        throw e
    }
}
