/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Build
* IBM UrbanCode Deploy
* IBM UrbanCode Release
* IBM AnthillPro
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

package com.urbancode.air.plugin.isam

import groovy.util.XmlSlurper
import groovy.json.JsonSlurper
import org.xml.sax.SAXException

public class TextBoxHelper {

    /*
     * Reads input. Determine if file or text. If file, it will try to read from the file, and
     * retrieve its contents. Then confirm that the given text is XML. String XML text is returned.
     *
     * param input  File or text that contains XML
     * param verbose  Prints out discovered XML if true
     * result       Returns confirmed XML string
     */
    public String getXMLText(String input, boolean verbose) {
        def xmlResult = getText(input, verbose)

        // Confirm gathered input is XML, else catch and fail
        try {
            XmlSlurper sluper = new XmlSlurper()
            sluper.parseText(xmlResult)
        }
        catch (IOException ex) {
            throw new IOException ("[Error]  XML input is invalid. Please review the XML format: ${ex.getMessage()}.")
        }
        catch (SAXException ex) {
            throw new SAXException ("[Error]  XML input is invalid. Please review the XML format: ${ex.getMessage()}.")
        }
        return xmlResult
    }

    /*
     * Reads input. Determine if file or text. If file, it will try to read from the file, and
     * retrieve its contents. Then confirm that the given text is JSON. String JSON text is returned.
     *
     * param input  File or text that contains JSON
     * param verbose  Prints out discovered JSON if true
     * result       Returns confirmed JSON string
     */
    public String getJSONText(String input, boolean verbose) {
        def jsonResult = getText(input, verbose)
        // Confirm gathered input is JSON, else catch and fail
        try {
            JsonSlurper sluper = new JsonSlurper()
            sluper.parseText(jsonResult)
        }
        catch (IOException ex) {
            throw new IOException ("[Error]  JSON input is invalid. Please review the JSON format: ${ex.getMessage()}.")
        }
        catch (SAXException ex) {
            throw new SAXException ("[Error]  JSON input is invalid. Please review the JSON format: ${ex.getMessage()}.")
        }
        return jsonResult
    }

    /*
     * Reads input. Determine if file or text. If file, it will try to read from the file, and
     * retrieve its contents.
     *
     * param input  File or text that contains text
     * param verbose  Prints out discovered text, if true
     * result       Returns confirmed text String
     */
    public String getText(String input, boolean verbose) {
        def result
        File file = new File(input)
        // Check if the given path exists
        if (file.isFile()) {
            // Retrieve file text
            result =  file.getText()
            println "[Ok]  Input is recognized as a file: ${input}."
        }
        else {
            // Else, the given text isn't a file
            result = input
            println "[Ok]  Input is recognized as text."
        }
        if (verbose) {
            println "Discovered Input:"
            println result
        }
        return result
    }
}