/*
* Licensed Materials - Property of IBM Corp.
* IBM UrbanCode Deploy
* (c) Copyright IBM Corporation 2016. All Rights Reserved.
*
* U.S. Government Users Restricted Rights - Use, duplication or disclosure restricted by
* GSA ADP Schedule Contract with IBM Corp.
*/

import com.urbancode.air.AirPluginTool
import com.urbancode.air.plugin.isam.ISAMHelper
import com.urbancode.air.plugin.isam.TextBoxHelper
import org.apache.http.impl.client.DefaultHttpClient

def apTool = new AirPluginTool(this.args[0], this.args[1])
ISAMHelper isam = new ISAMHelper()
TextBoxHelper tb = new TextBoxHelper()

def props = apTool.getStepProperties()
def hostname    = isam.checkHostname(props['hostname'])
def username    = props['username']
def password    = props['password']
def instanceId  = props['instanceId']
def stanzaId    = props['stanzaId']
def entryId     = props['entryId']
def value       = tb.getJSONText(props['value'], true)

// URL Format: https://{appliance_hostname}/wga/reverseproxy/{reverseproxy_id}/configuration/stanza/{stanza_id}/entry_name/{entry_name_id}
StringBuilder resource = new StringBuilder("reverseproxy/${instanceId}/configuration/stanza/${stanzaId}/entry_name/${entryId}")
String fullAddress = isam.createAPIAddress(hostname, resource.toString())
println "[Ok]  Constructed Address: " + fullAddress

// Create the REST call and run
DefaultHttpClient client = isam.createClient(username, password)

// Construct the issue specific address and postRequest
def statusCode = isam.updateConfigEntity(client, fullAddress, value)

apTool.setOutputProperty("StatusCode", String.valueOf(statusCode))
apTool.storeOutputProperties()

// 200 is the only successful Status Code
if (statusCode != 200) {
    System.exit(1)
}

