import java.io.*;
import java.util.*;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
final def isWindows = apTool.isWindows;

def wasProfilePath = props['WASProfilePath']
def wasAdminUsername = props['WASAdminUsername']
def wasAdminPassword = props['WASAdminPassword']
def wasDmgrHostname = props['WASDmgrHostname']
def wasDmgrPort = props['WASDmgrPort']

try {
    while (wasProfilePath.endsWith(File.separator)) {
        wasProfilePath = wasProfilePath.substring(0, wasProfilePath.length()-1);
    }
    def addName = "addNode."+(isWindows?"bat":"sh");
    def binDir = new File(wasProfilePath, "bin");
    def addExe = new File(binDir, addName);
    def ch = new CommandHelper(binDir);
    def cmdArgs = [addExe.absolutePath,
                       wasDmgrHostname,
                       wasDmgrPort,
                       "-username", wasAdminUsername,
                       "-password", wasAdminPassword];
    ch.runCommand("Running addNode", cmdArgs);
}
catch (Exception e) {
    println "Starting and registering a node failed.";
    System.exit(1);;
}
