import java.io.*;
import java.util.*;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
final def isWindows = apTool.isWindows;

def wasInstallPath = props['WASInstallPath']
def imInstallPath = props['IMInstallPath']
def imRepository = props['IMRepository']
def imShared = props['IMShared']
def versionName = props['VersionName']

try {
    while (imInstallPath.endsWith(File.separator)) {
        imInstallPath = imInstallPath.substring(0, imInstallPath.length()-1);
    }
    def toolsDir = new File(imInstallPath, "eclipse/tools");
    def imclName = "imcl"+(isWindows?".exe":"");
    def imclExe = new File(toolsDir, imclName);
    def ch = new CommandHelper(toolsDir);
    def cmdArgs = [imclExe.absolutePath,
                       "install", versionName,
                       "-repositories", imRepository,
                       "-installationDirectory", wasInstallPath,
                       "-acceptLicense",
                       "-showVerboseProgress"];

    if (imShared?.trim()) {
        cmdArgs << "-sharedResourcesDirectory";
        cmdArgs << imShared.trim();
    }

    ch.runCommand("Running imcl", cmdArgs);
}
catch (Exception e) {
    println "Installing WebSphere Application Server failed.";
    System.exit(1);;
}
