import java.io.*;
import java.util.*;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
final def isWindows = apTool.isWindows;

def wasInstallPath = props['WASInstallPath']
def wasAdminUsername = props['WASAdminUsername']
def wasAdminPassword = props['WASAdminPassword']

try {
    while (wasInstallPath.endsWith(File.separator)) {
        wasInstallPath = wasInstallPath.substring(0, wasInstallPath.length()-1);
    }
    def stopServerName = "stopServer."+(isWindows?"bat":"sh");
    def binDir = new File(wasInstallPath, "bin");
    def stopServerExe = new File(binDir, stopServerName);
    def ch = new CommandHelper(binDir);
    def cmdArgs = [stopServerExe.absolutePath,
                       "-user", wasAdminUsername,
                       "-password", wasAdminPassword];
    ch.runCommand("Running stopServer", cmdArgs);
}
catch (Exception e) {
    println "Stopping WebSphere Application Server process failed.";
    System.exit(1);;
}
