import java.io.*;
import java.util.*;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
final def isWindows = apTool.isWindows;

def wasInstallPath = props['WASInstallPath']
def profileTemplatePath = props['ProfileTemplatePath']
def wasProfileName = props['WASProfileName']
def wasProfilePath = props['WASProfilePath']
def wasAdminUsername = props['WASAdminUsername']
def wasAdminPassword = props['WASAdminPassword']

def wasCellName = props['WASCellName']
def wasNodeName = props['WASNodeName']
def wasHostName = props['WASHostName']
def wasPortsFile = props ['WASPortsFile']

try {
    while (wasInstallPath.endsWith(File.separator)) {
        wasInstallPath = wasInstallPath.substring(0, wasInstallPath.length()-1);
    }
    def manageProfilesName = "manageprofiles."+(isWindows?"bat":"sh");
    def binDir = new File(wasInstallPath, "bin");
    def manageProfilesExe = new File(binDir, manageProfilesName);
    def ch = new CommandHelper(binDir);
    def cmdArgs = [manageProfilesExe.absolutePath,
                       "-create",
                       "-templatePath", profileTemplatePath,
                       "-profileName", wasProfileName,
                       "-profilePath", wasProfilePath,
                       "-enableAdminSecurity", "true",
                       "-adminUserName", wasAdminUsername,
                       "-adminPassword", wasAdminPassword];

    if (wasPortsFile?.trim()) {
        cmdArgs << "-portsFile";
        cmdArgs << wasPortsFile.trim();
    }
    if (wasCellName?.trim()) {
        cmdArgs << "-cellName";
        cmdArgs << wasCellName.trim();
    }
    if (wasNodeName?.trim()) {
        cmdArgs << "-nodeName";
        cmdArgs << wasNodeName.trim();
    }
    if (wasHostName?.trim()) {
        cmdArgs << "-hostName";
        cmdArgs << wasHostName.trim();
    }

    ch.runCommand("Running manageprofiles", cmdArgs);
}
catch (Exception e) {
    println "Creating a profile failed.";
    System.exit(1);;
}
