import java.io.*;
import java.util.*;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
final def isWindows = apTool.isWindows;

def wasInstallPath = props['WASInstallPath']
def wasAdminUsername = props['WASAdminUsername']
def wasAdminPassword = props['WASAdminPassword']
def wasProfileName = props['WASProfileName']
def command = this.args[2];

try {
    while (wasInstallPath.endsWith(File.separator)) {
        wasInstallPath = wasInstallPath.substring(0, wasInstallPath.length()-1);
    }
    def commandName = command+(isWindows?".bat":".sh");
    def binDir = new File(wasInstallPath, "bin");
    def commandExe = new File(binDir, commandName);
    def ch = new CommandHelper(binDir);
    def cmdArgs = [commandExe.absolutePath,
                       "-user", wasAdminUsername,
                       "-password", wasAdminPassword,
                       "-profileName", wasProfileName];
    ch.runCommand(("Running " + command), cmdArgs);
}
catch (Exception e) {
    println "Running " + command + " failed.";
    System.exit(1);;
}
