import java.io.*;
import java.util.*;
import com.urbancode.air.CommandHelper;
import com.urbancode.air.AirPluginTool;

def apTool = new AirPluginTool(this.args[0], this.args[1]);
def props = apTool.getStepProperties();
final def isWindows = apTool.isWindows;

def wasInstallPath = props['WASInstallPath']
def wasProfileName = props['WASProfileName']
def wasProfilePath = props['WASProfilePath']
def deleteProfileDir = props['deleteProfileDir']

try {
    while (wasInstallPath.endsWith(File.separator)) {
        wasInstallPath = wasInstallPath.substring(0, wasInstallPath.length()-1);
    }
    def manageProfilesName = "manageprofiles."+(isWindows?"bat":"sh");
    def binDir = new File(wasInstallPath, "bin");
    def manageProfilesExe = new File(binDir, manageProfilesName);
    def ch = new CommandHelper(binDir);
    def cmdArgs = [manageProfilesExe.absolutePath,
                       "-delete",
                       "-profileName", wasProfileName,
                       "-profilePath", wasProfilePath];
    ch.runCommand("Running manageprofiles", cmdArgs);
    if (new File(wasProfilePath).exists() && deleteProfileDir == "true") {
      def ant = new AntBuilder();
      ant.delete(verbose: 'true', includeemptydirs: 'true') {
          fileset(dir:wasProfilePath, casesensitive: 'false', followsymlinks: 'false', defaultexcludes: 'false')
      }
  }
}
catch (Exception e) {
    println "Removing a WebSphere Deployment Manager profile failed.";
    System.exit(1);;
}
