/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.extRepo;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class ExtRepoHelper {
    private static final HttpClientBuilder builder = new HttpClientBuilder();
    private static CloseableHttpClient client;

    public static void createClient() {
        client = builder.buildClient();
    }

    public static void createClient(String username, String password) {
        builder.setPreemptiveAuthentication(true);
        builder.setUsername(username);
        builder.setPassword(password);
        ExtRepoHelper.createClient();
    }

    public static HttpResponse getOkResponse(String url) {
        CloseableHttpResponse response = null;
        HttpGet get = new HttpGet(url);
        get.addHeader("accept", "application/json");
        try {
            response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new IOException("Bad request status code" + response.getStatusLine().getStatusCode() + response.toString().replace("\n", ""));
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return response;
    }

    public static File downloadZOSZip(String url) {
        File tempFile = null;
        try {
            System.out.println("[action]  Attempting to download zOS package...");
            HttpResponse response = ExtRepoHelper.getOkResponse(url);
            tempFile = File.createTempFile("zOS-", ".zip");
            InputStream is = response.getEntity().getContent();
            FileOutputStream fos = new FileOutputStream(tempFile);
            int read = 0;
            byte[] buffer = new byte[32768];
            while ((read = is.read(buffer)) > 0) {
                fos.write(buffer, 0, read);
            }
            fos.close();
            is.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return tempFile;
    }
}

