/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.externalrepo.ExtRepoHelper;
import com.urbancode.commons.util.IO;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExtRepoDownload {
    private String extRepoURL;
    private String username;
    private String password;
    private String versionName;
    private String resourceId;
    private String packageVersion = "packageVersion";
    private Properties inputProperties;
    private Properties outputProperties;

    public ExtRepoDownload(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws IOException, Exception {
        try {
            File workDir = new File("").getCanonicalFile();
            this.extRepoURL = this.inputProperties.getProperty("extRepoURL");
            this.username = this.inputProperties.getProperty("username");
            this.password = this.inputProperties.getProperty("password");
            this.versionName = this.inputProperties.getProperty("versionName");
            this.resourceId = this.inputProperties.getProperty("resourceId");
            workDir = new File(workDir.getAbsolutePath() + File.separator + this.resourceId + File.separator + this.versionName).getCanonicalFile();
            if (workDir.isFile()) {
                throw new IllegalArgumentException("Working directory" + workDir + " is a file!");
            }
            workDir.mkdirs();
            if (this.username != null) {
                ExtRepoHelper.createClient(this.username, this.password);
            } else {
                ExtRepoHelper.createClient();
            }
            String downloadUrl = this.extRepoURL;
            File tempFile = null;
            File finalFile = new File(workDir, this.packageVersion + ".zip");
            try {
                tempFile = ExtRepoHelper.downloadZOSZip(downloadUrl);
            }
            catch (SecurityException se) {
                System.out.println("[error]  Could not download package:" + se.getClass().getSimpleName() + " " + se.getMessage());
            }
            if (tempFile != null) {
                System.out.println("[ok]  Downloaded package from repository");
                try {
                    IO.move(tempFile, finalFile);
                    System.out.println("[ok]  Moved downloaded package to the working directory");
                }
                catch (Exception ioe) {
                    System.out.println("[error]  Could not move downloaded file to requested directory:" + ioe.getMessage());
                }
                try {
                    tempFile.delete();
                    System.out.println("[ok]  Deleted temporary file");
                }
                catch (Exception ioe) {
                    System.out.println("[error]  Could not delete temporary file: " + ioe.getMessage());
                }
            } else {
                System.out.println("[error]  Could not download the package.");
            }
            String zipFilePath = workDir.getAbsolutePath() + "/" + this.packageVersion + ".zip";
            String destDirectory = workDir.getAbsolutePath();
            try {
                this.unzip(zipFilePath, destDirectory);
                finalFile.delete();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(8);
            }
        }
        catch (Exception e) {
            System.out.println(String.format("Exception message is  %s", e.getMessage()));
            e.printStackTrace();
            return 1;
        }
        return 0;
    }

    public void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }
}

