/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.externalrepo.ExtRepoHelper;
import com.urbancode.commons.util.IO;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ExtRepoDownload {
    private String extRepoURL;
    private String username;
    private String password;
    private String apiKey;
    private String versionName;
    private boolean apiKeyCheckBox;
    private boolean proxyCheckBox;
    private String httpProxyHost = "";
    private String httpProxyPort = "";
    private String resourceId;
    private String packageVersion = "packageVersion";
    private String packageZipFileName = "package.zip";
    private String packageManifestFileName = "packageManifest.xml";
    private Properties inputProperties;
    private Properties outputProperties;

    public ExtRepoDownload(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws IOException, Exception {
        block24: {
            try {
                File zipFile;
                File workDir = new File("").getCanonicalFile();
                this.extRepoURL = this.inputProperties.getProperty("extRepoURL");
                this.username = this.inputProperties.getProperty("username");
                this.password = this.inputProperties.getProperty("password");
                this.apiKey = this.inputProperties.getProperty("apiKey");
                this.apiKeyCheckBox = Boolean.valueOf(this.inputProperties.getProperty("apiKeyCheckBox"));
                this.proxyCheckBox = Boolean.valueOf(this.inputProperties.getProperty("proxyCheckBox"));
                this.versionName = this.inputProperties.getProperty("versionName");
                this.resourceId = this.inputProperties.getProperty("resourceId");
                workDir = new File(workDir.getAbsolutePath() + File.separator + this.resourceId + File.separator + this.versionName).getCanonicalFile();
                if (workDir.isFile()) {
                    throw new IllegalArgumentException("Working directory" + workDir + " is a file!");
                }
                if (workDir.exists() && workDir.isDirectory()) {
                    System.out.println("Deleting work directory - " + workDir);
                }
                workDir.mkdirs();
                if (this.proxyCheckBox) {
                    this.httpProxyHost = this.inputProperties.getProperty("httpProxyHost");
                    this.httpProxyPort = this.inputProperties.getProperty("httpProxyPort");
                    if (this.httpProxyHost == null || this.httpProxyHost.length() == 0) {
                        throw new Exception("httpProxyHost must be set.");
                    }
                    System.setProperty("http.proxyHost", this.httpProxyHost);
                    System.setProperty("http.proxyPort", this.httpProxyPort);
                    System.out.println(" Using Proxy Host " + this.httpProxyHost);
                    System.out.println(" Using Proxy Port " + this.httpProxyPort);
                }
                if (this.username == null || this.username.length() == 0) {
                    throw new Exception("username must be set.");
                }
                if (this.apiKeyCheckBox) {
                    if (this.apiKey == null || this.apiKey.length() == 0) {
                        throw new Exception("apiKey must be set.");
                    }
                    ExtRepoHelper.createClient(this.username, this.apiKey, this.httpProxyHost, this.httpProxyPort);
                } else {
                    if (this.password == null || this.password.length() == 0) {
                        throw new Exception("password must be set.");
                    }
                    ExtRepoHelper.createClient(this.username, this.password, this.httpProxyHost, this.httpProxyPort);
                }
                String downloadUrl = this.extRepoURL;
                File tempFile = null;
                File finalFile = new File(workDir, this.packageVersion + ".zip");
                try {
                    tempFile = ExtRepoHelper.downloadZOSZip(downloadUrl);
                }
                catch (FileNotFoundException se) {
                    System.out.println("[error]  Could not download package from Artifactory:" + se.getClass().getSimpleName() + " " + se.getMessage());
                    se.printStackTrace();
                    System.exit(1);
                }
                if (tempFile != null) {
                    try {
                        IO.move(tempFile, finalFile);
                        System.out.println(" Moved downloaded package to the working directory");
                    }
                    catch (IOException ioe) {
                        System.out.println("[error]  Could not move downloaded file to requested directory:" + ioe.getMessage());
                        ioe.printStackTrace();
                        System.exit(1);
                    }
                    try {
                        tempFile.delete();
                    }
                    catch (Exception ioe) {
                        System.out.println("[error]  Could not download the package. Internal error.  " + ioe.getMessage());
                        ioe.printStackTrace();
                        System.exit(1);
                    }
                    System.out.println("[ok]  Downloaded package from artifact repository");
                } else {
                    System.out.println("[error]  Could not download the package.");
                    System.exit(1);
                }
                String zipFilePath = workDir.getAbsolutePath() + "/" + this.packageVersion + ".zip";
                String destDirectory = workDir.getAbsolutePath();
                try {
                    this.unzip(zipFilePath, destDirectory);
                    finalFile.delete();
                }
                catch (FileNotFoundException ex) {
                    System.out.println("[error] Error in unziping the package.");
                    ex.printStackTrace();
                    System.exit(8);
                }
                File pkgManifestFile = new File(destDirectory + "/" + this.packageManifestFileName);
                if (!pkgManifestFile.exists()) {
                    System.out.println("Error: " + this.packageManifestFileName + " not found in external repository");
                    System.exit(1);
                }
                if (!this.isSecondVersion(pkgManifestFile) || !(zipFile = new File(zipFilePath = destDirectory + "/" + this.packageZipFileName)).exists()) break block24;
                this.extractPax(zipFilePath, new File(destDirectory));
                try {
                    zipFile.renameTo(new File(destDirectory + "/processed_" + this.packageZipFileName));
                }
                catch (Exception e) {
                    System.out.println("Error while renaming the " + this.packageZipFileName + " file");
                    e.printStackTrace();
                    System.exit(1);
                }
                System.out.println("Deployment package extracted successfully");
            }
            catch (Exception e) {
                System.out.println(String.format("Exception message is  %s", e.getMessage()));
                e.printStackTrace();
                return 1;
            }
        }
        return 0;
    }

    public void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    private void extractPax(String zipFilePath, File workDir) {
        int exitCode = -1;
        try {
            String line;
            String[] cmdArgs = new String[]{"pax", "-r", "-f", zipFilePath};
            ProcessBuilder pb = new ProcessBuilder(cmdArgs).directory(workDir);
            Process process = pb.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), "IBM-1047"));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream(), "IBM-1047"));
            while ((line = stdInput.readLine()) != null) {
                System.out.println(line);
            }
            stdInput.close();
            while ((line = stdError.readLine()) != null) {
                System.out.println(line);
            }
            stdError.close();
            process.waitFor();
            exitCode = process.exitValue();
            if (exitCode > 0) {
                System.out.println("ERROR: pax command failed with exit code - " + exitCode);
                while ((line = stdError.readLine()) != null) {
                    System.out.println(line);
                }
                System.exit(4);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(6);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(8);
        }
    }

    private boolean isSecondVersion(File verFile) throws FileNotFoundException, IOException {
        String splitStr;
        FileReader fr = new FileReader(verFile);
        BufferedReader br = new BufferedReader(fr);
        boolean secondVersion = false;
        String[] words = null;
        String input = "<manifest type=\"MANIFEST_LIST\" version=\"v2_0\"";
        block0: while ((splitStr = br.readLine()) != null) {
            for (String word : words = splitStr.split(">")) {
                if (!word.contains(input)) continue;
                secondVersion = true;
                continue block0;
            }
        }
        fr.close();
        return secondVersion;
    }
}

