/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.externalrepo.ExtRepoHelper;
import com.urbancode.commons.util.IO;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ExtRepoDownload {
    static final String ENCODING_CP037 = "CP037";
    static final String MANIFEST_NODE = "manifest";
    static final String MANIFEST_VERSION_ATTRIBUTE = "version";
    static final int ERR_CODE = 8;
    private String extRepoURL;
    private String username;
    private String password;
    private String apiKey;
    private String versionName;
    private boolean apiKeyCheckBox;
    private boolean proxyCheckBox;
    private String httpProxyHost = "";
    private String httpProxyPort = "";
    private String resourceId;
    private String packageVersion = "packageVersion";
    private String packageZipFileName = "package.zip";
    private String packageManifestFileName = "packageManifest.xml";
    private Properties inputProperties;
    private Properties outputProperties;

    public ExtRepoDownload(Properties inputProperties, Properties outputProperties) {
        this.inputProperties = inputProperties;
        this.outputProperties = outputProperties;
    }

    public int execute() throws IOException, Exception {
        block25: {
            try {
                File zipFile;
                File workDir = new File("").getCanonicalFile();
                this.extRepoURL = this.inputProperties.getProperty("extRepoURL");
                this.username = this.inputProperties.getProperty("username");
                this.password = this.inputProperties.getProperty("password");
                this.apiKey = this.inputProperties.getProperty("apiKey");
                this.apiKeyCheckBox = Boolean.valueOf(this.inputProperties.getProperty("apiKeyCheckBox"));
                this.proxyCheckBox = Boolean.valueOf(this.inputProperties.getProperty("proxyCheckBox"));
                this.versionName = this.inputProperties.getProperty("versionName");
                this.resourceId = this.inputProperties.getProperty("resourceId");
                String osName = System.getProperty("os.name").toLowerCase(Locale.US);
                workDir = new File(workDir.getAbsolutePath() + File.separator + this.resourceId + File.separator + this.versionName).getCanonicalFile();
                if (workDir.isFile()) {
                    throw new IllegalArgumentException("Working directory" + workDir + " is a file!");
                }
                if (workDir.exists() && workDir.isDirectory()) {
                    System.out.println("Deleting work directory - " + workDir);
                    this.deleteDirectory(workDir);
                }
                workDir.mkdirs();
                if (this.proxyCheckBox) {
                    this.httpProxyHost = this.inputProperties.getProperty("httpProxyHost");
                    this.httpProxyPort = this.inputProperties.getProperty("httpProxyPort");
                    if (this.httpProxyHost == null || this.httpProxyHost.length() == 0) {
                        throw new Exception("httpProxyHost must be set.");
                    }
                    System.setProperty("http.proxyHost", this.httpProxyHost);
                    System.setProperty("http.proxyPort", this.httpProxyPort);
                    System.out.println(" Using Proxy Host " + this.httpProxyHost);
                    System.out.println(" Using Proxy Port " + this.httpProxyPort);
                }
                if (this.username == null || this.username.length() == 0) {
                    throw new Exception("username must be set.");
                }
                if (this.apiKeyCheckBox) {
                    if (this.apiKey == null || this.apiKey.length() == 0) {
                        throw new Exception("apiKey must be set.");
                    }
                    ExtRepoHelper.createClient(this.username, this.apiKey, this.httpProxyHost, this.httpProxyPort);
                } else {
                    if (this.password == null || this.password.length() == 0) {
                        throw new Exception("password must be set.");
                    }
                    ExtRepoHelper.createClient(this.username, this.password, this.httpProxyHost, this.httpProxyPort);
                }
                String downloadUrl = this.extRepoURL;
                File tempFile = null;
                File finalFile = new File(workDir, this.packageVersion + ".zip");
                try {
                    tempFile = ExtRepoHelper.downloadZOSZip(downloadUrl);
                }
                catch (FileNotFoundException se) {
                    System.out.println("[error]  Could not download package from Artifactory:" + se.getClass().getSimpleName() + " " + se.getMessage());
                    se.printStackTrace();
                    System.exit(8);
                }
                if (tempFile != null) {
                    try {
                        IO.move(tempFile, finalFile);
                        System.out.println(" Moved downloaded package to the working directory to " + workDir);
                    }
                    catch (IOException ioe) {
                        System.out.println("[error]  Could not move downloaded file to requested directory:" + ioe.getMessage());
                        ioe.printStackTrace();
                        System.exit(8);
                    }
                    try {
                        tempFile.delete();
                    }
                    catch (Exception ioe) {
                        System.out.println("[error]  Could not download the package. Internal error.  " + ioe.getMessage());
                        ioe.printStackTrace();
                        System.exit(8);
                    }
                    System.out.println("[ok]  Downloaded package from artifact repository");
                } else {
                    System.out.println("[error]  Could not download the package.");
                    System.exit(8);
                }
                String zipFilePath = workDir.getAbsolutePath() + "/" + this.packageVersion + ".zip";
                String destDirectory = workDir.getAbsolutePath();
                try {
                    this.unzip(zipFilePath, destDirectory);
                    finalFile.delete();
                }
                catch (FileNotFoundException ex) {
                    System.out.println("[error] Error in unziping the package.");
                    ex.printStackTrace();
                    System.exit(8);
                }
                File pkgManifestFile = new File(destDirectory + "/" + this.packageManifestFileName);
                if (!pkgManifestFile.exists()) {
                    System.out.println("Error: " + this.packageManifestFileName + " not found in external repository");
                    System.exit(8);
                }
                if (!this.isSecondVersion(pkgManifestFile.getCanonicalPath()) || !(zipFile = new File(zipFilePath = destDirectory + "/" + this.packageZipFileName)).exists()) break block25;
                if (osName.equalsIgnoreCase("z/OS")) {
                    this.extractPax(zipFilePath, new File(destDirectory));
                    try {
                        zipFile.renameTo(new File(destDirectory + "/processed_" + this.packageZipFileName));
                    }
                    catch (Exception e) {
                        System.out.println("Error while renaming the " + this.packageZipFileName + " file");
                        e.printStackTrace();
                        System.exit(8);
                    }
                    System.out.println("Deployment package extracted successfully to " + destDirectory);
                    break block25;
                }
                System.out.println("Downloaded package.zip and packageManifest.xml to the directory " + destDirectory);
            }
            catch (Exception e) {
                System.out.println(String.format("Exception message is  %s", e.getMessage()));
                e.printStackTrace();
                return 1;
            }
        }
        return 0;
    }

    public void unzip(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                this.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdir();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }

    private void extractPax(String zipFilePath, File workDir) {
        int exitCode = -1;
        try {
            String line;
            String[] cmdArgs = new String[]{"pax", "-r", "-f", zipFilePath};
            ProcessBuilder pb = new ProcessBuilder(cmdArgs).directory(workDir);
            Process process = pb.start();
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), "IBM-1047"));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream(), "IBM-1047"));
            while ((line = stdInput.readLine()) != null) {
                System.out.println(line);
            }
            stdInput.close();
            while ((line = stdError.readLine()) != null) {
                System.out.println(line);
            }
            stdError.close();
            process.waitFor();
            exitCode = process.exitValue();
            if (exitCode > 0) {
                System.out.println("ERROR: pax command failed with exit code - " + exitCode);
                while ((line = stdError.readLine()) != null) {
                    System.out.println(line);
                }
                System.exit(4);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(6);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isSecondVersion(String manifestPath) throws IOException, XMLStreamException {
        FileInputStream shipListFileStream = null;
        boolean manifestNodeFound = false;
        boolean isNewPackage = false;
        try {
            shipListFileStream = new FileInputStream(manifestPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            System.exit(8);
        }
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader shiplistEventReader = inputFactory.createXMLEventReader(shipListFileStream, ENCODING_CP037);
        try {
            while (shiplistEventReader.hasNext() && !manifestNodeFound) {
                XMLEvent shipListReaderEvent = shiplistEventReader.nextEvent();
                switch (shipListReaderEvent.getEventType()) {
                    case 1: {
                        StartElement startElement = shipListReaderEvent.asStartElement();
                        String nodeName = startElement.getName().getLocalPart().trim();
                        if (!MANIFEST_NODE.equalsIgnoreCase(nodeName)) break;
                        String versionValue = this.getAttributeValue(startElement, MANIFEST_VERSION_ATTRIBUTE);
                        manifestNodeFound = true;
                        if (versionValue != null && versionValue.equals("v2_0")) {
                            isNewPackage = true;
                            break;
                        }
                        isNewPackage = false;
                        break;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(8);
        }
        finally {
            try {
                shipListFileStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(8);
            }
        }
        return isNewPackage;
    }

    private String getAttributeValue(StartElement startElement, String attributeName) {
        if (null == startElement || null == attributeName) {
            return null;
        }
        Iterator<Attribute> it = startElement.getAttributes();
        while (it.hasNext()) {
            String value;
            Attribute attr = it.next();
            if (!attr.getName().getLocalPart().trim().equalsIgnoreCase(attributeName) || null == (value = attr.getValue())) continue;
            return value.trim();
        }
        return null;
    }

    private boolean deleteDirectory(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        return this.deleteDir0(file);
    }

    private boolean deleteDir0(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                this.deleteDir0(f);
            }
        }
        return file.delete();
    }
}

