/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.download;

import com.urbancode.air.plugin.command.MissingInputException;
import java.util.Properties;

public class ExtRepoDownloadInputs {
    public static final String EXT_REPO_URL = "extRepoURL";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String API_KEY = "apiKey";
    public static final String PROXY_CHECK_BOX = "proxyCheckBox";
    public static final String VERSION_NAME = "versionName";
    public static final String RESOURCE_ID = "resourceId";
    public static final String ALLOW_INSECURE = "allowInsecure";
    public static final String HTTP_PROXY_HOST = "httpProxyHost";
    public static final String HTTP_PROXY_PORT = "httpProxyPort";
    public static final String USE_ATTLS = "USE_ATTLS";
    public static final String COMPONENT_NAME = "componentName";
    private static final String HTTPS = "https";
    private static final String HTTP = "http";
    private final String extRepoURL;
    private final String username;
    private final String password;
    private final String apiKey;
    private final boolean isProxyEnabled;
    private final String versionName;
    private final String resourceId;
    private final boolean isInsecureConnectionAllowed;
    private final String httpProxyHost;
    private final String httpProxyPort;
    private final String componentName;

    public ExtRepoDownloadInputs(Properties inputProperties) {
        String inputExtRepoURL = inputProperties.getProperty(EXT_REPO_URL).trim();
        this.username = inputProperties.getProperty(USERNAME).trim();
        this.password = inputProperties.getProperty(PASSWORD).trim();
        this.apiKey = inputProperties.getProperty(API_KEY).trim();
        this.isProxyEnabled = Boolean.parseBoolean(inputProperties.getProperty(PROXY_CHECK_BOX));
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.isInsecureConnectionAllowed = Boolean.parseBoolean(inputProperties.getProperty(ALLOW_INSECURE));
        this.httpProxyHost = inputProperties.getProperty(HTTP_PROXY_HOST).trim();
        this.httpProxyPort = inputProperties.getProperty(HTTP_PROXY_PORT).trim();
        boolean isAtTlsEnabled = Boolean.parseBoolean(inputProperties.getProperty(USE_ATTLS).trim());
        this.extRepoURL = isAtTlsEnabled ? inputExtRepoURL.replace(HTTPS, HTTP) : inputExtRepoURL;
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
    }

    public static ExtRepoDownloadInputs getValidatedInputs(Properties inputProperties) {
        ExtRepoDownloadInputs extRepoDownloadInputs = new ExtRepoDownloadInputs(inputProperties);
        extRepoDownloadInputs.validate();
        return extRepoDownloadInputs;
    }

    private void validate() {
        if (this.extRepoURL.isEmpty()) {
            throw new MissingInputException("External Repository URL cannot be empty");
        }
        if (!this.username.isEmpty() && this.password.isEmpty() && this.apiKey.isEmpty()) {
            throw new MissingInputException("Either Password or Api-Key/Token should be passed for external repository");
        }
        if (this.versionName.isEmpty()) {
            throw new MissingInputException("Version Name cannot be empty");
        }
        if (this.resourceId.isEmpty()) {
            throw new MissingInputException("Resource Id cannot be empty");
        }
        if (this.isProxyEnabled && this.httpProxyHost.isEmpty()) {
            throw new MissingInputException("Proxy is enabled but Http Proxy Host is empty");
        }
        if (this.componentName.isEmpty()) {
            throw new MissingInputException("Component name cannot be empty");
        }
    }

    public String getExtRepoURL() {
        return this.extRepoURL;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public boolean isProxyEnabled() {
        return this.isProxyEnabled;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public boolean isInsecureConnectionAllowed() {
        return this.isInsecureConnectionAllowed;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public String getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getComponentName() {
        return this.componentName;
    }
}

