/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.merge.common;

import com.urbancode.air.plugin.command.merge.ExtRepoType;
import com.urbancode.air.plugin.command.merge.common.MergeVersionsInput;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;

class ExternalRepoUploader {
    private static final String ZIP_EXTENSION = ".zip";
    private static final String HTTPS = "HTTPS";
    private static final String HTTP = "HTTP";
    private final File versionZip;
    private final String versionZipUrl;
    private final HttpClientBuilder2 builder;
    private final boolean isAtTlsEnabled;
    private String responseBody;
    private final ExtRepoType repositoryType;

    public ExternalRepoUploader(MergeVersionsInput pluginInputs, String versionZipPath) {
        this.builder = pluginInputs.getHttpClientBuilder();
        this.repositoryType = pluginInputs.getExtRepoType();
        this.isAtTlsEnabled = pluginInputs.isAtTlsEnabled();
        this.versionZip = new File(versionZipPath);
        this.versionZipUrl = pluginInputs.getExtRepoUrl() + File.separator + pluginInputs.getMergedVersion() + ZIP_EXTENSION;
    }

    public String getUrlToDownloadZip() {
        return this.versionZipUrl;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public void upload() throws IOException {
        System.out.println(" [Info] Uploading artifacts to " + (Object)((Object)this.repositoryType));
        ContentType contentType = ContentType.create((String)"application/octet-stream");
        FileEntity fileEntity = new FileEntity(this.versionZip, contentType);
        String url = this.isAtTlsEnabled ? this.versionZipUrl.replace(HTTPS, HTTP) : this.versionZipUrl;
        HttpPut put = new HttpPut(url);
        put.addHeader("Content-Encoding", "application/octet-stream");
        put.setEntity((HttpEntity)fileEntity);
        System.out.println(" [Info] Executing request " + put.getRequestLine());
        try (CloseableHttpClient client = this.builder.buildClient();){
            this.responseBody = (String)client.execute((HttpUriRequest)put, this.getResponseHandler());
        }
    }

    private ResponseHandler<String> getResponseHandler() {
        return response -> {
            int status = response.getStatusLine().getStatusCode();
            if (status >= 200 && status < 300) {
                HttpEntity entity;
                if (status == this.repositoryType.getSuccessStatusCode()) {
                    System.out.println("Version artifacts stored in External Repository server");
                }
                return (entity = response.getEntity()) != null ? EntityUtils.toString((HttpEntity)entity) : null;
            }
            System.out.println("HTTP response error code =" + response.getStatusLine().getStatusCode());
            throw new IOException("Bad request status code" + response.getStatusLine().getStatusCode() + response.toString().replace("\n", ""));
        };
    }
}

