/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.merge.common;

import com.urbancode.air.plugin.command.MissingInputException;
import com.urbancode.air.plugin.command.merge.ExtRepoType;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import java.util.Properties;

public abstract class MergeVersionsInput {
    public static final String MERGED_VERSION_NAME = "mergedVersionName";
    public static final String COMPONENT_NAME = "componentName";
    public static final String VERSIONS = "versions";
    public static final String EXT_REPO_URL = "extRepoURL";
    public static final String EXT_REPOSITORY = "extRepository";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String USE_AT_TLS = "useAtTls";
    public static final String ALLOW_INSECURE = "allowInsecure";
    private final String mergedVersion;
    private final String component;
    private final String versionsToMerge;
    protected final String extRepoUrl;
    protected final String extRepository;
    protected final String username;
    protected final String password;
    private final boolean isAtTlsEnabled;
    protected final boolean allowInsecureConnection;

    public MergeVersionsInput(Properties inputProperties) {
        this.mergedVersion = inputProperties.getProperty(MERGED_VERSION_NAME).trim();
        this.component = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.versionsToMerge = inputProperties.getProperty(VERSIONS).trim();
        this.isAtTlsEnabled = Boolean.parseBoolean(inputProperties.getProperty(USE_AT_TLS));
        this.extRepoUrl = inputProperties.getProperty(EXT_REPO_URL).trim();
        this.extRepository = inputProperties.getProperty(EXT_REPOSITORY).trim();
        this.username = inputProperties.getProperty(USERNAME).trim();
        this.password = inputProperties.getProperty(PASSWORD).trim();
        this.allowInsecureConnection = Boolean.parseBoolean(inputProperties.getProperty(ALLOW_INSECURE));
    }

    public String getComponent() {
        return this.component;
    }

    public String getVersionsToMerge() {
        return this.versionsToMerge;
    }

    public abstract HttpClientBuilder2 getHttpClientBuilder();

    public String getMergedVersion() {
        return this.mergedVersion;
    }

    public abstract ExtRepoType getExtRepoType();

    public abstract String getExtRepoUrl();

    public boolean isAtTlsEnabled() {
        return this.isAtTlsEnabled;
    }

    public void validate() {
        if (this.mergedVersion.isEmpty()) {
            throw new MissingInputException("Merged Version Name cannot be empty");
        }
        if (this.component.isEmpty()) {
            throw new MissingInputException("Component Name cannot be empty");
        }
        if (this.versionsToMerge.isEmpty()) {
            throw new MissingInputException("Versions to merge cannot be empty");
        }
        if (this.extRepoUrl.isEmpty()) {
            throw new MissingInputException("External Repo URL cannot be empty");
        }
        if (this.extRepository.isEmpty()) {
            throw new MissingInputException("Artifactory Repository is empty");
        }
        if (this.username.isEmpty()) {
            throw new MissingInputException("Username cannot be empty");
        }
        if (this.password.isEmpty()) {
            throw new MissingInputException("Password cannot be empty");
        }
    }
}

