/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.common;

import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackManifest;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;

public class DeployedVersion {
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private static final String DEPLOY_DIRECTORY = "deploy";
    private static final String CONTAINER_MAPPER_XML = "containerMapper.xml";
    private static final String ROLLBACK_MANIFEST_XML = "rollbackManifest.xml";
    private static final String BACKUP_ZIP = "backup.zip";
    static final String DEPLOY_BASE_PATH = "deployBasePath";
    static final String RESOURCE_ID = "resourceId";
    static final String COMPONENT_NAME = "componentName";
    static final String VERSION_NAME = "versionName";
    private final String deployBasePath;
    private final String resourceId;
    private final String componentName;
    private final String versionName;
    private final String versionDirPath;

    public DeployedVersion(Properties inputProperties) {
        this.deployBasePath = inputProperties.getProperty(DEPLOY_BASE_PATH).trim();
        this.checkIfEmpty(this.deployBasePath, "Deploy Base Path");
        if (!new File(this.deployBasePath).isDirectory()) {
            throw new IllegalArgumentException("Deploy Base Directory " + this.deployBasePath + " does not exist.");
        }
        this.resourceId = inputProperties.getProperty(RESOURCE_ID).trim();
        this.checkIfEmpty(this.resourceId, "Resource Id");
        this.componentName = inputProperties.getProperty(COMPONENT_NAME).trim();
        this.checkIfEmpty(this.componentName, "Component Name");
        this.versionName = inputProperties.getProperty(VERSION_NAME).trim();
        this.checkIfEmpty(this.versionName, "Version Name");
        this.versionDirPath = this.deployBasePath + File.separator + DEPLOY_DIRECTORY + File.separator + this.resourceId + File.separator + this.componentName + File.separator + this.versionName;
    }

    private void checkIfEmpty(String value, String name) {
        if (value.isEmpty()) {
            throw new IllegalArgumentException(name + " is required.");
        }
    }

    public PackageManifest getPackageManifest() throws IOException, XMLStreamException {
        String packageManifestFilePath = this.versionDirPath + File.separator + PACKAGE_MANIFEST_XML;
        if (!this.isFileExist(packageManifestFilePath)) {
            throw new IllegalArgumentException(packageManifestFilePath + " not found, please make sure the version has been successfully deployed");
        }
        String containerMapperFilePath = this.versionDirPath + File.separator + CONTAINER_MAPPER_XML;
        if (this.isFileExist(containerMapperFilePath)) {
            return PackageManifest.from(packageManifestFilePath, containerMapperFilePath);
        }
        return PackageManifest.from(packageManifestFilePath);
    }

    public RollbackManifest getRollbackManifest() throws IOException, XMLStreamException {
        String rollbackManifestPath = this.versionDirPath + File.separator + ROLLBACK_MANIFEST_XML;
        if (!this.isFileExist(rollbackManifestPath)) {
            throw new IllegalArgumentException(rollbackManifestPath + " not found, please make sure the version has been successfully deployed");
        }
        return RollbackManifest.from(rollbackManifestPath);
    }

    public boolean exist() {
        return this.isFileExist(this.versionDirPath + File.separator + PACKAGE_MANIFEST_XML);
    }

    public boolean hasBackup() {
        return this.isFileExist(this.versionDirPath + File.separator + BACKUP_ZIP);
    }

    private boolean isFileExist(String filePath) {
        return new File(filePath).isFile();
    }

    public String getDeployBasePath() {
        return this.deployBasePath;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String getVersionName() {
        return this.versionName;
    }

    public String getVersionDirPath() {
        return this.versionDirPath;
    }
}

