/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.download;

import com.ibm.urbancode.zos.checksum.ChecksumVerifier;
import com.ibm.urbancode.zos.helpers.FileHelper;
import com.ibm.urbancode.zos.helpers.TarUtil;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.urbancode.air.plugin.command.ChecksumFileDownloader;
import com.urbancode.air.plugin.command.ExtRepoHelper;
import com.urbancode.air.plugin.command.MissingInputException;
import com.urbancode.air.plugin.command.ZipExtractor;
import com.urbancode.air.plugin.command.download.ExtRepoDownloadInputs;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class ExtRepoDownload {
    private static final int EXIT_CODE_8 = 8;
    private static final int EXIT_CODE_0 = 0;
    private static final String PACKAGE_VERSION_ZIP = "packageVersion.zip";
    public static final String PACKAGE_ZIP = "package.zip";
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private String versionDirPath;
    ExtRepoDownloadInputs pluginInputs;
    private final Properties inputProperties;

    public ExtRepoDownload(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() {
        try {
            this.pluginInputs = ExtRepoDownloadInputs.getValidatedInputs(this.inputProperties);
            this.versionDirPath = this.getVersionDirPath(this.pluginInputs);
            this.createVersionDirectory(this.versionDirPath);
            String packageVersionZipPath = this.versionDirPath + File.separator + PACKAGE_VERSION_ZIP;
            ExtRepoHelper.download(this.pluginInputs, packageVersionZipPath);
            ZipExtractor.extract(packageVersionZipPath, this.versionDirPath);
            System.out.println(" [Info] Extracted version files from the downloaded zip file");
            this.validateChecksum();
            String packageZipPath = this.versionDirPath + File.separator + PACKAGE_ZIP;
            String packageManifestPath = this.versionDirPath + File.separator + PACKAGE_MANIFEST_XML;
            PackageManifest packageManifest = PackageManifest.from((String)packageManifestPath);
            if (FileHelper.isFileExist((String)packageZipPath) && packageManifest.isNewPackageFormat()) {
                TarUtil.untar((String)packageZipPath, (String)this.versionDirPath);
                System.out.println(" [Info] Deployment package extracted successfully to " + this.versionDirPath);
                String processedPackageZipPath = this.versionDirPath + "/processed_" + PACKAGE_ZIP;
                FileHelper.renameFile((String)packageZipPath, (String)processedPackageZipPath);
            }
            return 0;
        }
        catch (MissingInputException | IllegalArgumentException knownRuntimeException) {
            System.out.println(" [Error] " + knownRuntimeException.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 8;
    }

    private void validateChecksum() throws Exception {
        if (this.isChecksumFileAvailable()) {
            ChecksumVerifier.verify((String)this.versionDirPath);
        }
    }

    private boolean isChecksumFileAvailable() throws Exception {
        try {
            ChecksumFileDownloader.downloadFromCodestation(this.pluginInputs.getComponentName(), this.pluginInputs.getVersionName(), this.versionDirPath);
        }
        catch (Exception e) {
            if (e.getMessage().contains("404: File not found") || e.getMessage().contains(" 400: Error processing command: File not found")) {
                System.out.println("No checksum properties found for this version, will ignore checksum validation");
                return false;
            }
            throw e;
        }
        return true;
    }

    private String getVersionDirPath(ExtRepoDownloadInputs pluginInputs) throws IOException {
        String currentWorkDir = new File(".").getCanonicalPath();
        return currentWorkDir + File.separator + pluginInputs.getResourceId() + File.separator + pluginInputs.getVersionName();
    }

    private void createVersionDirectory(String versionDirPath) throws IOException {
        if (FileHelper.isDirectoryExist((String)versionDirPath)) {
            System.out.println(" [Info] Deleting existing version directory - " + versionDirPath);
            FileHelper.cleanDirectory((String)versionDirPath);
        }
        System.out.println(" [Info] Creating version directory - " + versionDirPath);
        FileHelper.createDir((String)versionDirPath);
    }
}

