/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.merge.jfrog;

import com.urbancode.air.plugin.command.merge.ExtRepoType;
import com.urbancode.air.plugin.command.merge.common.MergeVersionsInput;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import java.io.File;
import java.util.Properties;

final class MergeArtifactoryVersionsInputs
extends MergeVersionsInput {
    public static final String HTTP_PROXY_HOST = "httpProxyHost";
    public static final String HTTP_PROXY_PORT = "httpProxyPort";
    private final String httpProxyHost;
    private final String httpProxyPort;

    private MergeArtifactoryVersionsInputs(Properties inputProperties) {
        super(inputProperties);
        this.httpProxyHost = inputProperties.getProperty(HTTP_PROXY_HOST).trim();
        this.httpProxyPort = inputProperties.getProperty(HTTP_PROXY_PORT).trim();
    }

    public static MergeVersionsInput getValidatedInputs(Properties inputProperties) {
        MergeArtifactoryVersionsInputs mergeArtifactoryVersionsInputs = new MergeArtifactoryVersionsInputs(inputProperties);
        ((MergeVersionsInput)mergeArtifactoryVersionsInputs).validate();
        return mergeArtifactoryVersionsInputs;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public ExtRepoType getExtRepoType() {
        return ExtRepoType.ARTIFACTORY;
    }

    @Override
    public String getExtRepoUrl() {
        return this.extRepoUrl + File.separator + this.extRepository;
    }

    @Override
    public HttpClientBuilder2 getHttpClientBuilder() {
        HttpClientBuilder2 builder = new HttpClientBuilder2();
        builder.setPreemptiveAuthentication(true);
        builder.setUsername(this.username);
        builder.setPassword(this.password);
        if (!this.httpProxyHost.isEmpty()) {
            System.out.println("Using Proxy Host : " + this.httpProxyHost);
            builder.setProxyHost(this.httpProxyHost);
        }
        if (!this.httpProxyPort.isEmpty()) {
            System.out.println("Using Proxy Port : " + this.httpProxyPort);
            builder.setProxyPort(Integer.parseInt(this.httpProxyPort));
        }
        if (this.allowInsecureConnection) {
            System.out.println("[Info] Allowing insecure connections. Review with your security admins before allowing insecure connections...");
            builder.setTrustAllCerts(true);
        }
        return builder;
    }
}

