/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.ssl;

import com.urbancode.commons.util.logging.LogUtil;
import com.urbancode.commons.util.ssl.SSLConfiguratorPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Logger;

public class SSLConfiguratorDefaultPolicy
implements SSLConfiguratorPolicy {
    private static final String SSLv2Hello = "SSLv2Hello";
    public static final String POLICY_PROTO_CONFIG_PROPERTY = "SSLConfiguratorDefaultPolicy.protoconfig";
    private static final String[] DEFAULT_ALLOW_PROTOS = new String[]{"TLSv1.3", "TLSv1.2", "TLSv1.1", "TLSv1"};
    private static final String[] DEFAULT_DENY_PROTOS = new String[]{"SSLv2", "SSLv3"};
    public static final String POLICY_CIPHER_CONFIG_PROPERTY = "SSLConfiguratorDefaultPolicy.cipherconfig";
    private static final String[] DEFAULT_ALLOW_CIPHERS = new String[0];
    private static final String[] DEFAULT_DENY_CIPHERS = new String[0];
    private static final Logger log = Logger.getLogger(SSLConfiguratorDefaultPolicy.class);
    private String[] allowProtos;
    private String[] denyProtos;
    private String[] allowCiphers;
    private String[] denyCiphers;

    public SSLConfiguratorDefaultPolicy() {
        HashSet<String> allowProtos = new HashSet<String>();
        Collections.addAll(allowProtos, DEFAULT_ALLOW_PROTOS);
        HashSet<String> denyProtos = new HashSet<String>();
        Collections.addAll(denyProtos, DEFAULT_DENY_PROTOS);
        HashSet<String> allowCiphers = new HashSet<String>();
        Collections.addAll(allowCiphers, DEFAULT_ALLOW_CIPHERS);
        HashSet<String> denyCiphers = new HashSet<String>();
        Collections.addAll(denyCiphers, DEFAULT_DENY_CIPHERS);
        String protoString = System.getProperty(POLICY_PROTO_CONFIG_PROPERTY);
        List<String> protoConfig = this.split(protoString);
        for (String elem : protoConfig) {
            if (elem.startsWith("+")) {
                allowProtos.add(elem.substring(1));
                denyProtos.remove(elem.substring(1));
                continue;
            }
            if (elem.startsWith("-")) {
                denyProtos.add(elem.substring(1));
                allowProtos.remove(elem.substring(1));
                continue;
            }
            allowProtos.add(elem);
        }
        this.allowProtos = allowProtos.toArray(new String[0]);
        this.denyProtos = denyProtos.toArray(new String[0]);
        String cipherString = System.getProperty(POLICY_CIPHER_CONFIG_PROPERTY);
        List<String> cipherConfig = this.split(cipherString);
        for (String elem : cipherConfig) {
            if (elem.startsWith("+")) {
                allowCiphers.add(elem.substring(1));
                denyCiphers.remove(elem.substring(1));
                continue;
            }
            if (elem.startsWith("-")) {
                denyCiphers.add(elem.substring(1));
                allowCiphers.remove(elem.substring(1));
                continue;
            }
            allowCiphers.add(elem);
        }
        this.allowCiphers = allowCiphers.toArray(new String[0]);
        this.denyCiphers = denyCiphers.toArray(new String[0]);
    }

    @Override
    public String[] enabledProtocols(String[] supportedProtocols, boolean server) {
        LinkedHashSet<String> enabledProtos = new LinkedHashSet<String>();
        enabledProtos.addAll(Arrays.asList(supportedProtocols));
        if (this.allowProtos.length > 0) {
            enabledProtos.retainAll(Arrays.asList(this.allowProtos));
        }
        if (this.denyProtos.length > 0) {
            enabledProtos.removeAll(Arrays.asList(this.denyProtos));
        }
        if (!server) {
            enabledProtos.remove(SSLv2Hello);
        }
        return enabledProtos.toArray(new String[enabledProtos.size()]);
    }

    @Override
    public String[] enabledCipherSuites(String[] supportedCipherSuites) {
        LinkedHashSet enabledCipherSuites = new LinkedHashSet();
        Collections.addAll(enabledCipherSuites, supportedCipherSuites);
        LinkedHashSet supportedAllowChipers = new LinkedHashSet();
        Collections.addAll(supportedAllowChipers, supportedCipherSuites);
        supportedAllowChipers.retainAll(Arrays.asList(this.allowCiphers));
        Iterator itr = enabledCipherSuites.iterator();
        while (itr.hasNext()) {
            String cipher = (String)itr.next();
            if (cipher.contains("_anon_")) {
                itr.remove();
                LogUtil.logTrace(log, "default policy would disable anon ciphersuite " + cipher);
                continue;
            }
            if (cipher.contains("_EXPORT_") || cipher.contains("_EXPORT1024_")) {
                itr.remove();
                LogUtil.logTrace(log, "default policy would disable EXPORT ciphersuite " + cipher);
                continue;
            }
            if (cipher.contains("_NULL_")) {
                itr.remove();
                LogUtil.logTrace(log, "default policy would disable NULL ciphersuite " + cipher);
                continue;
            }
            if (cipher.contains("_DES_")) {
                itr.remove();
                LogUtil.logTrace(log, "default policy would disable DES ciphersuite " + cipher);
                continue;
            }
            if (cipher.contains("_3DES_")) {
                itr.remove();
                LogUtil.logTrace(log, "default policy would disable 3DES ciphersuite " + cipher);
                continue;
            }
            if (cipher.contains("_DH_")) {
                itr.remove();
                LogUtil.logTrace(log, "default policy would disable DH (or DHE) ciphersuite " + cipher);
                continue;
            }
            if (cipher.contains("_RC4_")) {
                itr.remove();
                LogUtil.logTrace(log, "default policy would disable RD4 ciphersuite " + cipher);
                continue;
            }
            if (!cipher.contains("_MD5")) continue;
            itr.remove();
            LogUtil.logTrace(log, "default policy would disable MD5 ciphersuite " + cipher);
        }
        enabledCipherSuites.addAll(supportedAllowChipers);
        if (this.denyCiphers.length > 0) {
            enabledCipherSuites.removeAll(Arrays.asList(this.denyCiphers));
        }
        return enabledCipherSuites.toArray(new String[0]);
    }

    private List<String> split(String value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value != null) {
            for (String token : value.split(",")) {
                if ((token = token.trim()).length() <= 0) continue;
                result.add(token);
            }
        }
        return result;
    }
}

