/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.filter;

import com.urbancode.commons.web.WebConfig;
import com.urbancode.commons.web.controller.NoSuchDestinationException;
import com.urbancode.persistence.hibernate.HibernateUtil;
import com.urbancode.security.SecurityException;
import com.urbancode.transaction.TransactionUtil;
import com.urbancode.transaction.TransactionUtilFactory;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ExceptionHandlingFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(ExceptionHandlingFilter.class);
    private List<Class<IOException>> ignoredIoExceptions = new ArrayList<Class<IOException>>();
    private List<Class<ServletException>> ignoredServletExceptions = new ArrayList<Class<ServletException>>();
    private Map<Class<Exception>, String> forcedExceptionMessages = new HashMap<Class<Exception>, String>();
    private ErrorNotifier errorNotifier = null;

    private static Throwable unwrapException(Throwable e) {
        ServletException se;
        Throwable unwrappedException = e;
        if (unwrappedException.getClass().equals(ServletException.class) && (se = (ServletException)e).getRootCause() != null) {
            unwrappedException = se.getRootCause();
        }
        if (unwrappedException.getClass().equals(ServletException.class) && !unwrappedException.equals(e)) {
            unwrappedException = ExceptionHandlingFilter.unwrapException(unwrappedException);
        }
        return unwrappedException;
    }

    public void init(FilterConfig filterConfig) {
        String errorNotifierClassName;
        String forcedMessagesString;
        String ignoredClassesString = filterConfig.getInitParameter("ignoredExceptionClasses");
        if (ignoredClassesString != null) {
            String[] classNames;
            ignoredClassesString = ignoredClassesString.trim();
            for (String className : classNames = ignoredClassesString.split("\n")) {
                className = className.trim();
                try {
                    Class<?> exceptionClass = Class.forName(className);
                    Object exception = exceptionClass.newInstance();
                    if (!(exception instanceof ServletException) && !(exception instanceof IOException)) {
                        throw new ExceptionInInitializerError(className + "is not a subclass of ServletException or IOException");
                    }
                    if (exception instanceof ServletException) {
                        Class<?> servletExceptionCLass = exceptionClass;
                        this.ignoredServletExceptions.add(servletExceptionCLass);
                        continue;
                    }
                    if (!(exception instanceof IOException)) continue;
                    Class<?> ioExceptionCLass = exceptionClass;
                    this.ignoredIoExceptions.add(ioExceptionCLass);
                }
                catch (ClassNotFoundException e) {
                    throw new ExceptionInInitializerError(e);
                }
                catch (InstantiationException e) {
                    throw new ExceptionInInitializerError(e);
                }
                catch (IllegalAccessException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
        }
        if ((forcedMessagesString = filterConfig.getInitParameter("forcedExceptionMessages")) != null) {
            String[] exceptionsWithMessages;
            forcedMessagesString = forcedMessagesString.trim();
            for (String exceptionWithMessage : exceptionsWithMessages = forcedMessagesString.split("\n")) {
                String[] split = (exceptionWithMessage = exceptionWithMessage.trim()).split(":", 2);
                if (split.length < 2) {
                    throw new ExceptionInInitializerError("Incorrect forced exception message format: " + exceptionWithMessage);
                }
                String exceptionClassName = split[0];
                String message = split[1];
                try {
                    Class<?> exceptionClass = Class.forName(exceptionClassName);
                    this.forcedExceptionMessages.put(exceptionClass, message);
                }
                catch (ClassNotFoundException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
        }
        if ((errorNotifierClassName = filterConfig.getInitParameter("errorNotifierClass")) != null) {
            try {
                Class<?> errorNotifierClass = Class.forName(errorNotifierClassName);
                this.errorNotifier = (ErrorNotifier)errorNotifierClass.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new ExceptionInInitializerError(e);
            }
            catch (InstantiationException e) {
                throw new ExceptionInInitializerError(e);
            }
            catch (IllegalAccessException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
        logger.info("Filter initialized");
        logger.info("    ignored ServletExceptions: " + this.ignoredServletExceptions);
        logger.info("    ignored IOExceptions: " + this.ignoredIoExceptions);
        logger.info("    forced messages for: " + this.forcedExceptionMessages.keySet());
        logger.info("    error notifier: " + errorNotifierClassName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (Exception e) {
            Throwable root;
            block23: {
                boolean isBrokenPipe = false;
                for (Throwable brokenPipeCheck = root = ExceptionHandlingFilter.unwrapException(e); brokenPipeCheck != null; brokenPipeCheck = brokenPipeCheck.getCause()) {
                    if (!brokenPipeCheck.getClass().getName().contains("ClientAbortException") && (brokenPipeCheck.getMessage() == null || !brokenPipeCheck.getMessage().contains("Broken pipe"))) continue;
                    isBrokenPipe = true;
                    break;
                }
                if (isBrokenPipe) {
                    logger.warn("A client cancelled a request before the response was sent: " + request.getRequestURI());
                    logger.debug(root.toString(), root);
                }
                if (this.errorNotifier != null) {
                    this.errorNotifier.sendErrorNotifications(root);
                }
                if (root instanceof SecurityException || root instanceof java.lang.SecurityException) {
                    response.setStatus(403);
                } else if (root instanceof NoSuchDestinationException) {
                    response.setStatus(404);
                } else {
                    Integer forcedCode = WebConfig.getInstance().getForcedErrorCode(500);
                    if (forcedCode == null) {
                        forcedCode = 500;
                    }
                    response.setStatus(forcedCode.intValue());
                }
                if (this.ignoredIoExceptions.contains(root.getClass())) {
                    logger.debug("Ignoring IOException: " + root.getClass().getCanonicalName());
                    throw (IOException)root;
                }
                if (this.ignoredServletExceptions.contains(root.getClass())) {
                    logger.debug("Ignoring ServletException: " + root.getClass().getCanonicalName());
                    throw (ServletException)root;
                }
                if (this.forcedExceptionMessages.containsKey(root.getClass())) {
                    Class<?> exceptionClass = root.getClass();
                    String message = this.forcedExceptionMessages.get(root.getClass());
                    try {
                        Constructor<?> constructor = exceptionClass.getConstructor(String.class, Throwable.class);
                        root = (Throwable)constructor.newInstance(message, root);
                    }
                    catch (Exception e1) {
                        try {
                            Constructor<?> constructor = exceptionClass.getConstructor(String.class, Serializable.class);
                            root = (Throwable)constructor.newInstance(message, root);
                        }
                        catch (Exception e2) {
                            root = new Exception(message, root);
                        }
                    }
                }
                logger.error(root.toString(), root);
                try {
                    Class<?> staleObjectStateExceptionClass = Class.forName("org.hibernate.StaleObjectStateException");
                    if (!staleObjectStateExceptionClass.isInstance(e)) break block23;
                    TransactionUtil tx = TransactionUtilFactory.getInstance();
                    try {
                        if (tx != null && tx.isActive()) {
                            tx.rollback(e);
                        }
                    }
                    finally {
                        HibernateUtil.getSessionFactory().getCurrentSession().clear();
                        HibernateUtil.getSessionFactory().getCurrentSession().close();
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            request.setAttribute("exception", (Object)root);
            request.getRequestDispatcher(WebConfig.getInstance().getExceptionView()).forward(req, res);
        }
    }

    public void destroy() {
        logger.info("Filter destroyed");
    }

    public static abstract class ErrorNotifier {
        protected abstract void sendErrorNotifications(Throwable var1);

        protected String formatError(Throwable error) {
            StackTraceElement[] stackTraceElements;
            String result = error.getClass().getCanonicalName() + ":" + error.getMessage() + "\n";
            for (StackTraceElement element : stackTraceElements = error.getStackTrace()) {
                result = result + "\tat " + element.getClassName() + "." + element.getMethodName() + "(" + element.getFileName() + ":" + element.getLineNumber() + ")\n";
            }
            if (error.getCause() != null) {
                result = result + "Caused by: " + this.formatError(error.getCause());
            }
            return result;
        }
    }
}

