/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.web.util;

import com.urbancode.commons.web.WebException;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCollector {
    private static final String IMAGES_COLLECTED_ATTRIBUTE_NAME = ImageCollector.class.getCanonicalName() + ".ImagesCollected";

    public static List<File> collect(HttpServletRequest request, String imgDirRelativePath, final long maxFileLength) throws WebException {
        ArrayList<File> result = new ArrayList<File>();
        HttpSession session = request.getSession();
        if (session.getAttribute(IMAGES_COLLECTED_ATTRIBUTE_NAME) == null) {
            ServletContext context = session.getServletContext();
            File imgDir = new File(context.getRealPath(imgDirRelativePath));
            if (!imgDir.exists()) {
                throw new WebException("Cannot find directory " + imgDir);
            }
            if (!imgDir.isDirectory()) {
                throw new WebException(imgDir + " is not a directory");
            }
            File[] imgFiles = imgDir.listFiles(new FileFilter(){

                public boolean accept(File file) {
                    return file.isFile() && file.length() < maxFileLength && (file.getName().toLowerCase().endsWith(".jpg") || file.getName().toLowerCase().endsWith(".jpeg") || file.getName().toLowerCase().endsWith(".gif") || file.getName().toLowerCase().endsWith(".png"));
                }
            });
            if (imgFiles != null) {
                result.addAll(Arrays.asList(imgFiles));
            }
            session.setAttribute(IMAGES_COLLECTED_ATTRIBUTE_NAME, (Object)true);
        }
        return result;
    }
}

