/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.Check;
import com.urbancode.commons.util.assertionerrors.CallDoesNotReturnError;
import java.io.InterruptedIOException;

public final class Exceptions {
    public static boolean isInterruption(Throwable throwable) {
        return throwable instanceof InterruptedException || throwable instanceof InterruptedIOException;
    }

    public static boolean isCauseInterruption(Throwable throwable) {
        Check.nonNull(throwable, "throwable");
        while (throwable != null) {
            if (Exceptions.isInterruption(throwable)) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static boolean isRootCauseInterruption(Throwable throwable) {
        Throwable root = Exceptions.getRootCause(throwable);
        return Exceptions.isInterruption(root);
    }

    public static Throwable getRootCause(Throwable throwable) {
        Check.nonNull(throwable, "throwable");
        Throwable root = throwable;
        while (throwable != null) {
            root = throwable;
            throwable = throwable.getCause();
        }
        return root;
    }

    public static void throwIt(Throwable throwable) {
        Exceptions.throwItMagically(throwable);
        throw new CallDoesNotReturnError();
    }

    private static <T extends Throwable> void throwItMagically(Throwable throwable) throws T {
        throw throwable;
    }

    private Exceptions() {
    }
}

