/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.rollback;

import com.ibm.urbancode.zos.xml.utils.common.XmlHelper;
import com.ibm.urbancode.zos.xml.utils.rollback.ActionNode;
import com.ibm.urbancode.zos.xml.utils.rollback.RollbackContainer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RollbackManifest {
    private static final String CREATED_TAG = "created";
    private static final String UPDATED_TAG = "updated";
    private static final String DELETED_TAG = "deleted";
    private final List<RollbackContainer> createdContainers = new ArrayList<RollbackContainer>();
    private final List<RollbackContainer> updatedContainers = new ArrayList<RollbackContainer>();
    private final List<RollbackContainer> deletedContainers = new ArrayList<RollbackContainer>();
    private String version;

    private RollbackManifest() {
    }

    public static RollbackManifest from(String rollbackManifestPath) throws IOException, XMLStreamException {
        RollbackManifest rollbackManifest = new RollbackManifest();
        try (InputStream inputStream = Files.newInputStream(Paths.get(rollbackManifestPath, new String[0]), new OpenOption[0]);){
            rollbackManifest.parse(inputStream);
        }
        return rollbackManifest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(InputStream rollbackInputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        try (XMLStreamReader xmlStreamReader = null;){
            xmlStreamReader = inputFactory.createXMLStreamReader(rollbackInputStream, XmlHelper.getFileEncoding());
            while (xmlStreamReader.hasNext()) {
                if (xmlStreamReader.next() != 1) continue;
                this.processStartElement(xmlStreamReader);
            }
        }
    }

    private void processStartElement(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        String nodeName = xmlStreamReader.getLocalName().trim();
        if (nodeName.equalsIgnoreCase("manifest")) {
            this.version = XmlHelper.getAttributeValue(xmlStreamReader, "version");
        } else if (this.isActionTag(nodeName)) {
            this.processActionElement(xmlStreamReader, nodeName);
        }
    }

    private void processActionElement(XMLStreamReader xmlStreamReader, String nodeName) throws XMLStreamException {
        List<RollbackContainer> containers = ActionNode.getContainers(xmlStreamReader, nodeName);
        if (nodeName.equals(CREATED_TAG)) {
            this.createdContainers.addAll(containers);
        } else if (nodeName.equals(UPDATED_TAG)) {
            this.updatedContainers.addAll(containers);
        } else {
            this.deletedContainers.addAll(containers);
        }
    }

    private boolean isActionTag(String nodeName) {
        return CREATED_TAG.equalsIgnoreCase(nodeName) || UPDATED_TAG.equalsIgnoreCase(nodeName) || DELETED_TAG.equalsIgnoreCase(nodeName);
    }

    public List<RollbackContainer> getCreatedContainers() {
        return Collections.unmodifiableList(this.createdContainers);
    }

    public List<RollbackContainer> getUpdatedContainers() {
        return Collections.unmodifiableList(this.updatedContainers);
    }

    public List<RollbackContainer> getDeletedContainers() {
        return Collections.unmodifiableList(this.deletedContainers);
    }

    public String getVersion() {
        return this.version;
    }
}

