/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util;

import com.urbancode.commons.util.Check;
import java.io.InterruptedIOException;
import org.apache.log4j.Logger;

public class ExceptionSupport {
    public boolean isRootCauseInterruption(Throwable throwable) {
        Throwable root = this.getRootCause(throwable);
        return root instanceof InterruptedException || root instanceof InterruptedIOException;
    }

    public Throwable getRootCause(Throwable throwable) {
        Check.nonNull(throwable, "throwable");
        Throwable root = throwable;
        while (throwable != null) {
            root = throwable;
            throwable = throwable.getCause();
        }
        return root;
    }

    public void logError(Logger logger, String message, Throwable throwable) {
        logger.error((Object)this.newLogMessage(message, throwable));
        this.logStacktrace(logger, message, throwable);
    }

    public void logFatal(Logger logger, String message, Throwable throwable) {
        logger.fatal((Object)this.newLogMessage(message, throwable));
        this.logStacktrace(logger, message, throwable);
    }

    protected String newLogMessage(String message, Throwable throwable) {
        String throwableMessage = throwable.getMessage();
        return message + (throwableMessage == null ? "" : ": " + throwableMessage);
    }

    protected void logStacktrace(Logger logger, String message, Throwable throwable) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(message + " (stacktrace)"), throwable);
        }
    }
}

