/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.util.query;

import com.urbancode.commons.util.query.QueryFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class QueryResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<T> results;
    private long totalRecords = 0L;
    private final long startRecord;

    public QueryResult(QueryFilter filter) {
        this.startRecord = filter.getStartRecord();
    }

    public QueryResult(long startRecord) {
        this.startRecord = startRecord;
    }

    public void setResults(Collection<T> results) {
        this.results = new ArrayList<T>();
        for (T result : results) {
            this.results.add(result);
        }
    }

    public void setResults(T[] results) {
        this.results = new ArrayList<T>();
        for (T result : results) {
            this.results.add(result);
        }
    }

    public List<T> getResults() {
        return Collections.unmodifiableList(this.results);
    }

    public T getFirstResult() {
        if (this.results.isEmpty()) {
            return null;
        }
        return this.results.get(0);
    }

    public T getUniqueResult() {
        if (this.results.isEmpty()) {
            return null;
        }
        if (this.results.size() > 1 || this.totalRecords != 1L) {
            throw new RuntimeException("Query result is not unique");
        }
        return this.results.get(0);
    }

    public void setTotalRecords(long totalRecords) {
        this.totalRecords = totalRecords;
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public String getContentRangeString() {
        if (this.totalRecords == 0L) {
            return "items 0-0/0";
        }
        return String.format("items %d-%d/%d", this.startRecord, this.getEndRecord(), this.totalRecords);
    }

    public long getStartRecord() {
        return this.startRecord;
    }

    public long getEndRecord() {
        if (this.results.isEmpty()) {
            return this.startRecord;
        }
        return this.startRecord + (long)this.results.size() - 1L;
    }
}

