/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.commons.httpcomponentsutil;

import com.urbancode.commons.httpcomponentsutil.ApplySSLSocketFactory;
import com.urbancode.commons.httpcomponentsutil.ConnectionCleaner;
import com.urbancode.commons.httpcomponentsutil.FlexibleSSLSocketFactory;
import com.urbancode.commons.httpcomponentsutil.HttpClientConnectionManagerCleaner;
import com.urbancode.commons.httpcomponentsutil.HttpClientPackage;
import com.urbancode.commons.httpcomponentsutil.PreemptiveAuthInterceptor;
import com.urbancode.commons.httpcomponentsutil.SharedConnectionCleaner;
import com.urbancode.commons.httpcomponentsutil.TimeoutHelper;
import com.urbancode.commons.util.ssl.OpenX509TrustManager;
import com.urbancode.commons.util.ssl.SSLContextProtocolDetector;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class HttpClientBuilder2 {
    private boolean trustAllCerts;
    private int timeoutMillis = -1;
    private String username;
    private String password;
    private String proxyHost;
    private int proxyPort = -1;
    private String proxyUsername;
    private String proxyPassword;
    private boolean preemptiveAuthentication;
    private int maxConnsPerRoute = -1;
    private int maxConns = -1;
    private long idleConnectionTimeout = 30000L;
    private KeyManager[] keyManagers;
    private HostnameVerifier hostnameVerifier;
    private boolean useSharedIdleConnectionCleaner = true;
    private TrustManager[] trustManagers;
    private boolean disableCookies;
    private HttpClientConnectionManager connectionManager;
    private RedirectStrategy redirectStrategy;
    private boolean redirectHandlingDisabled;
    private boolean automaticRetriesDisabled;

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setTimeoutMillis(int timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    public void setTrustAllCerts(boolean trustAllCerts) {
        this.trustAllCerts = trustAllCerts;
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        if (trustManagers != null) {
            trustManagers = (TrustManager[])trustManagers.clone();
        }
        this.trustManagers = trustManagers;
    }

    public void setKeyManagers(KeyManager ... keyManagers) {
        if (keyManagers != null) {
            keyManagers = (KeyManager[])keyManagers.clone();
        }
        this.keyManagers = keyManagers;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public void setConnectionManager(HttpClientConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
        if (connectionManager != null) {
            this.maxConnsPerRoute = -1;
            this.maxConns = -1;
        }
    }

    public void setMaxConnsPerRoute(int maxConnsPerRoute) {
        this.connectionManager = null;
        this.maxConnsPerRoute = maxConnsPerRoute;
    }

    public void setMaxConns(int maxConns) {
        this.connectionManager = null;
        this.maxConns = maxConns;
    }

    public void setPreemptiveAuthentication(boolean preemptiveAuthentication) {
        this.preemptiveAuthentication = preemptiveAuthentication;
    }

    public void setIdleConnectionTimeout(long idleConnectionTimeout) {
        this.idleConnectionTimeout = idleConnectionTimeout;
    }

    public void setUseSharedIdleConnectionCleaner(boolean useSharedIdleConnectionCleaner) {
        this.useSharedIdleConnectionCleaner = useSharedIdleConnectionCleaner;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setDisableCookies(boolean disableCookies) {
        this.disableCookies = disableCookies;
    }

    public void setRedirectStrategy(RedirectStrategy redirectStrategy) {
        this.redirectStrategy = redirectStrategy;
    }

    public void setRedirectHandlingDisabled(boolean redirectHandlingDisabled) {
        this.redirectHandlingDisabled = redirectHandlingDisabled;
    }

    public void setAutomaticRetriesDisabled(boolean automaticRetriesDisabled) {
        this.automaticRetriesDisabled = automaticRetriesDisabled;
    }

    public HttpClientBuilder buildClientBuilder() {
        return this.buildClientBuilderPackage().getBuilder();
    }

    public CloseableHttpClient buildClient() {
        return this.buildClientPackage().getClient();
    }

    public HttpClientPackage buildClientPackage() {
        return this.buildClientBuilderPackage().build();
    }

    private HttpClientBuilderPackage buildClientBuilderPackage() {
        int timeout = new TimeoutHelper().getTimeout(this.timeoutMillis);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        Registry<ConnectionSocketFactory> socketFactoryRegistry = ApplySSLSocketFactory.buildSocketFactoryRegistry(this.buildSocketFactory());
        HttpClientConnectionManager connManager = this.connectionManager;
        if (connManager == null) {
            SocketConfig.Builder socketConfigBuilder = SocketConfig.custom().setSoReuseAddress(true).setSoKeepAlive(true).setTcpNoDelay(true);
            if (timeout > 0) {
                socketConfigBuilder.setSoTimeout(timeout);
            }
            SocketConfig socketConfig = socketConfigBuilder.build();
            int maxConnsPerRoute = this.maxConnsPerRoute;
            int maxConns = this.maxConns;
            if (maxConnsPerRoute < 0) {
                maxConnsPerRoute = 50;
            }
            if (maxConns < 0) {
                maxConns = 100;
            }
            if (maxConns < maxConnsPerRoute) {
                maxConns = maxConnsPerRoute;
            }
            PoolingHttpClientConnectionManager poolingConnManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, null, null, null, -1L, TimeUnit.MILLISECONDS);
            poolingConnManager.setDefaultSocketConfig(socketConfig);
            if (maxConns > 0) {
                poolingConnManager.setMaxTotal(maxConns);
            }
            if (maxConnsPerRoute > 0) {
                poolingConnManager.setDefaultMaxPerRoute(maxConnsPerRoute);
            }
            connManager = poolingConnManager;
            clientBuilder.setConnectionManager((HttpClientConnectionManager)poolingConnManager);
        } else {
            clientBuilder.addInterceptorFirst((HttpRequestInterceptor)new ApplySSLSocketFactory(socketFactoryRegistry));
            clientBuilder.setConnectionManager(connManager);
        }
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        if (this.proxyHost != null && this.proxyHost.length() > 0) {
            HttpHost proxy = new HttpHost(this.proxyHost, this.proxyPort);
            clientBuilder.setProxy(proxy);
            if (StringUtils.isNotEmpty((CharSequence)this.proxyUsername)) {
                ProxyAuthenticationStrategy strat = new ProxyAuthenticationStrategy();
                clientBuilder.setProxyAuthenticationStrategy((AuthenticationStrategy)strat);
                UsernamePasswordCredentials proxyCredentials = new UsernamePasswordCredentials(this.proxyUsername, this.proxyPassword);
                credsProvider.setCredentials(new AuthScope(this.proxyHost, this.proxyPort), (Credentials)proxyCredentials);
            }
        }
        if (this.username != null && this.password != null) {
            UsernamePasswordCredentials clientCredentials = new UsernamePasswordCredentials(this.username, this.password);
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)clientCredentials);
        }
        clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
        if (this.disableCookies) {
            clientBuilder.disableCookieManagement();
        }
        RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build();
        clientBuilder.setDefaultRequestConfig(defaultRequestConfig);
        if (this.redirectHandlingDisabled) {
            clientBuilder.disableRedirectHandling();
        }
        clientBuilder.setRedirectStrategy(this.redirectStrategy);
        if (this.automaticRetriesDisabled) {
            clientBuilder.disableAutomaticRetries();
        }
        if (this.preemptiveAuthentication) {
            clientBuilder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor());
        }
        return new HttpClientBuilderPackage(clientBuilder, connManager, (CredentialsProvider)credsProvider);
    }

    private SSLConnectionSocketFactory buildSocketFactory() {
        SSLContext sslContext;
        try {
            sslContext = SSLContext.getInstance(SSLContextProtocolDetector.detectSslContextProtocol());
            KeyManager[] km = this.keyManagers;
            TrustManager[] tm = this.trustManagers;
            if (this.trustAllCerts) {
                tm = new TrustManager[]{new OpenX509TrustManager()};
            }
            sslContext.init(km, tm, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        SSLSocketFactory factory = sslContext.getSocketFactory();
        String[] supportedProtocols = sslContext.createSSLEngine().getSupportedProtocols();
        FlexibleSSLSocketFactory flexibleSSLSocketFactory = new FlexibleSSLSocketFactory(factory, supportedProtocols);
        HostnameVerifier hostNameVerifier = this.hostnameVerifier;
        if (hostNameVerifier == null && this.trustAllCerts) {
            hostNameVerifier = NoopHostnameVerifier.INSTANCE;
        }
        return new SSLConnectionSocketFactory((SSLSocketFactory)flexibleSSLSocketFactory, hostNameVerifier);
    }

    class HttpClientBuilderPackage {
        private final HttpClientConnectionManager connectionManager;
        private final CredentialsProvider credentialsProvider;
        private final HttpClientBuilder builder;

        HttpClientBuilderPackage(HttpClientBuilder builder, HttpClientConnectionManager connectionManager, CredentialsProvider credentialsProvider) {
            this.builder = builder;
            this.builder.getClass();
            this.connectionManager = connectionManager;
            this.connectionManager.getClass();
            this.credentialsProvider = credentialsProvider;
            this.credentialsProvider.getClass();
        }

        HttpClientBuilder getBuilder() {
            return this.builder;
        }

        HttpClientPackage build() {
            if (HttpClientBuilder2.this.idleConnectionTimeout > 0L) {
                HttpClientConnectionManagerCleaner adapter = new HttpClientConnectionManagerCleaner(this.connectionManager, HttpClientBuilder2.this.idleConnectionTimeout, TimeUnit.MILLISECONDS);
                if (HttpClientBuilder2.this.useSharedIdleConnectionCleaner) {
                    SharedConnectionCleaner.track(adapter);
                } else {
                    new ConnectionCleaner(adapter).start();
                }
            }
            return new HttpClientPackage(this.builder.build(), this.connectionManager, this.credentialsProvider);
        }
    }
}

