/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.download.ExtRepoDownloadInputs;
import com.urbancode.air.plugin.command.merge.common.MergeVersionsInput;
import com.urbancode.ud.client.VersionClient;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.UUID;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class VersionClientUtil {
    private static final String VERSION_IMPORT_TRUE = "true";
    private static final String IBM_1047_ENCODING = "IBM-1047";
    private final VersionClient versionClient;

    public VersionClientUtil() throws URISyntaxException {
        String udPass = "{\"token\" : \"" + System.getenv("AUTH_TOKEN") + "\"}";
        String webUrl = System.getenv("AH_WEB_URL");
        this.versionClient = new VersionClient(new URI(webUrl), "PasswordIsAuthToken", udPass);
    }

    public String getDeployManifest(ExtRepoDownloadInputs extRepoDownloadInputs) throws IOException {
        return this.versionClient.getZOSVersionDeployManifest(extRepoDownloadInputs.getVersionId(), extRepoDownloadInputs.getCurrentVersionId(), Charset.forName(IBM_1047_ENCODING));
    }

    public String getVersionId(String component, String version) throws Exception {
        return this.versionClient.getVersionId(component, version).toString();
    }

    public void deleteVersion(UUID versionId) throws IOException {
        this.versionClient.deleteVersion(versionId);
    }

    public JSONObject getVersion(String versionId) throws JSONException, IOException {
        return this.versionClient.getVersion(versionId);
    }

    public UUID createZosVersion(String packageManifestInUTF8Path, MergeVersionsInput pluginInputs, String mergedVersionType) throws JSONException, IOException {
        return this.versionClient.createZosVersion(pluginInputs.getComponent(), pluginInputs.getMergedVersion(), mergedVersionType, packageManifestInUTF8Path, pluginInputs.getExtRepoType().toString(), VERSION_IMPORT_TRUE);
    }

    public void setVersionProperties(MergeVersionsInput pluginInputs, Map<String, String> versionPropertiesMap) throws IOException {
        for (Map.Entry<String, String> versionProperty : versionPropertiesMap.entrySet()) {
            this.versionClient.setVersionProperty(pluginInputs.getMergedVersion(), pluginInputs.getComponent(), versionProperty.getKey(), versionProperty.getValue(), false);
        }
    }

    public void markVersionImportingAsFinished(String componentName, UUID versionId) throws IOException {
        this.versionClient.markImportFinished(componentName, versionId.toString());
    }
}

