/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.generate.artifact.info.utils;

import com.ibm.urbancode.zos.generate.artifact.info.utils.ServerInputs;
import com.ibm.urbancode.zos.xml.utils.common.FileUtil;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.urbancode.commons.util.ssl.XTrustProvider;
import com.urbancode.ud.client.VersionClient;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;

public final class ServerManifest {
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private static final File workingDir = new File(".");
    private static final String DEPLOY_MANIFEST_XML = "deployManifest.xml";

    private ServerManifest() {
    }

    public static PackageManifest from(ServerInputs pluginInputs) throws Exception {
        String versionWorkingDir = ServerManifest.getVersionDirPathInWorkingDir(pluginInputs.getVersionName(), pluginInputs.getResourceId());
        if (pluginInputs.isLinkedVersion()) {
            VersionClient versionClient = ServerManifest.getVersionClient();
            String deployManifestXml = versionClient.getZOSVersionDeployManifest(pluginInputs.getVersionId(), pluginInputs.getCurrentVersionId(), Charset.forName("IBM-1047"));
            String deployManifestFilePath = versionWorkingDir + File.separator + DEPLOY_MANIFEST_XML;
            FileUtil.writeStringToFile(deployManifestXml, deployManifestFilePath);
            return PackageManifest.from(deployManifestFilePath);
        }
        ServerManifest.downloadPackageManifest(pluginInputs.getComponentName(), pluginInputs.getVersionName(), versionWorkingDir);
        return PackageManifest.from(versionWorkingDir + PACKAGE_MANIFEST_XML);
    }

    private static String getVersionDirPathInWorkingDir(String versionName, String resourceId) throws IOException {
        return workingDir.getCanonicalPath() + File.separator + resourceId + File.separator + versionName;
    }

    private static void downloadPackageManifest(String componentName, String versionName, String versionWorkingDir) throws Exception {
        VersionClient versionClient = ServerManifest.getVersionClient();
        XTrustProvider.install();
        try {
            versionClient.downloadFiles(componentName, versionName, versionWorkingDir, PACKAGE_MANIFEST_XML);
        }
        catch (Exception e) {
            System.out.println("Failed to locate metadata for version.\nGenerate artifact information works for either deployed versions or versions created on server version 6.1.1.6 or later.");
            throw e;
        }
    }

    private static VersionClient getVersionClient() throws URISyntaxException {
        String udUser = "PasswordIsAuthToken";
        String udPass = "{\"token\" : \"" + System.getenv("AUTH_TOKEN") + "\"}";
        String webUrl = System.getenv("AH_WEB_URL");
        return new VersionClient(new URI(webUrl), udUser, udPass);
    }
}

