/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.xml.utils.deploy;

import com.ibm.urbancode.zos.xml.utils.deploy.Inputs;
import com.ibm.urbancode.zos.xml.utils.deploy.Reference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class Resource
implements Comparable<Resource> {
    private final String name;
    private String type;
    private String resourceDeployType;
    private String containerDeployType;
    private final Map<String, String> customerProperties = new LinkedHashMap<String, String>();
    private Inputs inputs;
    private String lastModifiedTimestamp;
    private Reference reference;

    Resource(String name) {
        this.name = name;
    }

    public Inputs getInputs() {
        return this.inputs;
    }

    void setInputs(Inputs inputs) {
        this.inputs = inputs;
    }

    public String getName() {
        return this.name;
    }

    public String getResourceDeployType() {
        return this.resourceDeployType;
    }

    public String getContainerDeployType() {
        return this.containerDeployType;
    }

    void setResourceDeployType(String deployType) {
        this.resourceDeployType = deployType;
    }

    void setContainerDeployType(String deployType) {
        this.containerDeployType = deployType;
    }

    public Map<String, String> getCustomerProperties() {
        return Collections.unmodifiableMap(this.customerProperties);
    }

    void addCustomerProperty(String name, String value) {
        this.customerProperties.put(name, value);
    }

    public String getType() {
        return this.type;
    }

    void setType(String type) {
        this.type = type;
    }

    void setLastModifiedTimestamp(String lastModifiedTimestamp) {
        this.lastModifiedTimestamp = lastModifiedTimestamp;
    }

    public String getLastModifiedTimestamp() {
        return this.lastModifiedTimestamp;
    }

    @Override
    public int compareTo(Resource other) {
        return this.name.compareTo(other.getName());
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)o;
        return Objects.equals(other.getName(), this.name) && Objects.equals(other.getType(), this.type);
    }

    public Reference getReference() {
        return this.reference;
    }

    public void setReference(Reference reference) {
        this.reference = reference;
    }
}

