/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.merge.nexus;

import com.urbancode.air.plugin.command.MissingInputException;
import com.urbancode.air.plugin.command.merge.ExtRepoType;
import com.urbancode.air.plugin.command.merge.common.MergeVersionsInput;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import java.io.File;
import java.util.Properties;

final class MergeNexusVersionsInputs
extends MergeVersionsInput {
    private static final String REPOSITORY = "repository";
    public static final String EXT_RAW_DIRECTORY = "extRawDirectory";
    private final String extRawDirectory;

    private MergeNexusVersionsInputs(Properties inputProperties) {
        super(inputProperties);
        this.extRawDirectory = inputProperties.getProperty(EXT_RAW_DIRECTORY).trim();
    }

    public static MergeVersionsInput getValidatedInputs(Properties inputProperties) {
        MergeNexusVersionsInputs mergeNexusVersionsInputs = new MergeNexusVersionsInputs(inputProperties);
        ((MergeVersionsInput)mergeNexusVersionsInputs).validate();
        return mergeNexusVersionsInputs;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.extRawDirectory.isEmpty()) {
            throw new MissingInputException("Raw Directory is empty");
        }
    }

    @Override
    public ExtRepoType getExtRepoType() {
        return ExtRepoType.NEXUS;
    }

    @Override
    public String getExtRepoUrl() {
        return this.extRepoUrl + File.separator + REPOSITORY + File.separator + this.extRepository + File.separator + this.extRawDirectory;
    }

    @Override
    public HttpClientBuilder2 getHttpClientBuilder() {
        HttpClientBuilder2 builder = new HttpClientBuilder2();
        builder.setPreemptiveAuthentication(true);
        builder.setUsername(this.username);
        builder.setPassword(this.password);
        if (this.allowInsecureConnection) {
            System.out.println("[Info] Allowing insecure connections. Review with your security admins before allowing insecure connections...");
            builder.setTrustAllCerts(true);
        }
        return builder;
    }
}

