/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.automation.v3;

import com.ibm.team.enterprise.automation.CpDataset;
import com.ibm.team.enterprise.automation.ScriptFileGenerator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;

final class V3ScriptFileGenerator
extends ScriptFileGenerator {
    private static final String MVS = "MVS";

    private V3ScriptFileGenerator(String workDirPath, List<CpDataset> cpDatasets) {
        super(workDirPath, cpDatasets);
    }

    public static File generate(String workDirPath, List<CpDataset> cpDatasets) throws Exception {
        V3ScriptFileGenerator scriptFileGenerator = new V3ScriptFileGenerator(workDirPath, cpDatasets);
        return ((ScriptFileGenerator)scriptFileGenerator).generateFile();
    }

    @Override
    public File generateFile() throws Exception {
        this.validateCpOptionForDeployTypes();
        File directory = new File(this.workDirPath);
        Path mvsDir = directory.toPath().resolve(MVS);
        Files.createDirectories(mvsDir, new FileAttribute[0]);
        if (Files.notExists(mvsDir, new LinkOption[0])) {
            throw new RuntimeException("Failed to create directory " + mvsDir);
        }
        File tempScriptFile = this.createTempScriptFile(directory);
        this.writeScriptStatementsToFile(tempScriptFile);
        return tempScriptFile;
    }

    private void validateCpOptionForDeployTypes() {
        HashMap<String, String> deployTypeToCpTypeMapping = new HashMap<String, String>();
        for (CpDataset cpDataset : this.cpDatasets) {
            if (deployTypeToCpTypeMapping.containsKey(cpDataset.getDeployType())) {
                String existingCpOptionForThisDeployType = (String)deployTypeToCpTypeMapping.get(cpDataset.getDeployType());
                if (existingCpOptionForThisDeployType.equalsIgnoreCase(cpDataset.getCpOption())) continue;
                throw new UnsupportedOperationException("Conflicting cp option found for deploy type " + cpDataset.getDeployType());
            }
            deployTypeToCpTypeMapping.put(cpDataset.getDeployType(), cpDataset.getCpOption());
        }
    }

    private void writeScriptStatementsToFile(File tempFile) throws IOException {
        try (BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(tempFile));){
            bufferedWriter.append("#!/bin/sh");
            bufferedWriter.newLine();
            this.writeCpCommands(bufferedWriter);
        }
    }

    private void writeCpCommands(BufferedWriter bufferedWriter) throws IOException {
        for (CpDataset cpDataset : this.cpDatasets) {
            if (cpDataset.getDeployType() == null || cpDataset.getDeployType().isEmpty()) {
                throw new UnsupportedOperationException("Missing deployType for container " + cpDataset.getName() + ".Cannot package artifacts without deployType.");
            }
            if (cpDataset.getDsType().equals("PDS")) {
                this.writeCpCommandForPdsDataset(bufferedWriter, cpDataset);
                continue;
            }
            this.writeCpCommandForSequentialDataset(bufferedWriter, cpDataset);
        }
    }

    private void writeCpCommandForPdsDataset(BufferedWriter bufferedWriter, CpDataset cpDataset) throws IOException {
        if (cpDataset.getMembers().isEmpty()) {
            System.out.println(" [INFO] Dataset " + cpDataset.getName() + " is an empty PDS.");
            return;
        }
        Path pdsDir = Paths.get(this.getTargetPath(cpDataset), new String[0]);
        if (Files.notExists(pdsDir, new LinkOption[0])) {
            Files.createDirectory(pdsDir, new FileAttribute[0]);
            if (Files.notExists(pdsDir, new LinkOption[0])) {
                throw new RuntimeException("Failed to create directory " + pdsDir);
            }
        }
        for (String member : cpDataset.getMembers()) {
            String cpCommand = this.getCpCommand(cpDataset.getName() + "(" + member + ")", pdsDir + File.separator + member, cpDataset.getCpOption());
            bufferedWriter.append(cpCommand);
            this.addCommandCheck(bufferedWriter);
        }
    }

    private String getTargetPath(CpDataset cpDataset) {
        return Paths.get(this.workDirPath, new String[0]).resolve(MVS).resolve(cpDataset.getDeployType()).toString();
    }

    private void writeCpCommandForSequentialDataset(BufferedWriter bufferedWriter, CpDataset cpDataset) throws IOException {
        String cpCommand = this.getCpCommand(cpDataset.getName(), this.getTargetPath(cpDataset), cpDataset.getCpOption());
        bufferedWriter.append(cpCommand);
        this.addCommandCheck(bufferedWriter);
    }
}

