/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.merge.common;

import com.ibm.urbancode.zos.helpers.FileHelper;
import com.ibm.urbancode.zos.xml.utils.deploy.PackageManifest;
import com.urbancode.air.plugin.command.FileUtil;
import com.urbancode.air.plugin.command.VersionClientUtil;
import com.urbancode.air.plugin.command.ZipExtractor;
import com.urbancode.air.plugin.command.merge.common.ExtRepoVersionDownloader;
import com.urbancode.air.plugin.command.merge.common.ExternalRepoUploader;
import com.urbancode.air.plugin.command.merge.common.MergeVersionsInput;
import com.urbancode.air.plugin.command.merge.common.PackageZipMerger;
import com.urbancode.air.plugin.command.merge.common.Version;
import com.urbancode.air.plugin.command.merge.common.ZipCompressor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONObject;

public class MergeVersions {
    private static final String PACKAGE_VERSION_ZIP = "packageVersion.zip";
    private static final String VERSION_TYPE_INCREMENTAL = "Incremental";
    private static final String PACKAGE_ZIP = "package.zip";
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private static final String PACKAGE_MANIFEST_PREFIX = "packageManifest_";
    private static final String XML_EXTENSION = ".xml";
    private static final String PACKAGE_PREFIX = "package_";
    private static final String ZIP_EXTENSION = ".zip";
    private static final String UTF_8_EXTENSION = ".utf8";
    private static final String UCD_VERSION_ISMERGED = "ucd.version.ismerged";
    private static final String EXT_REPO_URL_VERSION_PROPERTY_NAME = "extRepoURL";
    private static final String VERSION_TYPE_FULL = "FULL";
    private static final String HTTPS = "HTTPS";
    private static final String HTTP = "HTTP";
    private final Map<String, String> versionPropertiesMap = new HashMap<String, String>();
    private final File workDir;
    private final MergeVersionsInput pluginInputs;
    private VersionClientUtil versionClientUtil;
    private boolean isNewPackageFormat = false;

    public MergeVersions(MergeVersionsInput mergeVersionsInput) {
        this.pluginInputs = mergeVersionsInput;
        this.workDir = new File(".");
        this.versionPropertiesMap.put(UCD_VERSION_ISMERGED, Boolean.TRUE.toString());
    }

    public void execute() throws Exception {
        this.versionClientUtil = new VersionClientUtil();
        System.out.println(" [Info] Cleaning work directory - " + this.workDir.getCanonicalPath());
        FileHelper.cleanDirectory((String)this.workDir.getCanonicalPath());
        List<Version> versions = this.getOrderedVersions(this.pluginInputs.getComponent(), this.pluginInputs.getVersionsToMerge());
        this.setMergedVersionsProperty(versions);
        this.downloadVersionsToBeMerged(versions, this.pluginInputs);
        this.createMergedVersionDirectory(this.pluginInputs.getMergedVersion());
        this.createMergedPackageManifestXml(versions, this.pluginInputs.getMergedVersion());
        this.createMergedPackageZip(versions, this.pluginInputs);
        String packageManifestInUTF8Path = this.getVersionPackageManifestPath(this.pluginInputs.getMergedVersion()) + UTF_8_EXTENSION;
        String mergedVersionType = this.getMergedVersionType(versions);
        UUID versionId = this.versionClientUtil.createZosVersion(packageManifestInUTF8Path, this.pluginInputs, mergedVersionType);
        this.uploadVersionArtifactsToExternalRepository(this.pluginInputs, versionId);
        this.versionClientUtil.markVersionImportingAsFinished(this.pluginInputs.getComponent(), versionId);
        this.versionClientUtil.setVersionProperties(this.pluginInputs, this.versionPropertiesMap);
        this.printVersionSummary(versions);
    }

    private void printVersionSummary(List<Version> versions) {
        System.out.println(" [Info] Created merged version " + this.pluginInputs.getMergedVersion() + " with below versions:");
        versions.forEach(version -> System.out.println("\tId: " + version.getId() + "\tName: " + version.getName()));
    }

    private List<Version> getOrderedVersions(String component, String versionsToMerge) throws Exception {
        String[] versionLines;
        HashSet<Version> versions = new HashSet<Version>();
        for (String versionLine : versionLines = versionsToMerge.split("\\n")) {
            if ((versionLine = versionLine.trim()).isEmpty()) continue;
            String versionId = this.versionClientUtil.getVersionId(component, versionLine);
            JSONObject jsonObject = this.versionClientUtil.getVersion(versionId);
            Version version = new Version(versionLine.trim(), versionId, jsonObject);
            if (versions.add(version)) continue;
            throw new IllegalArgumentException("Duplicate version " + versionLine);
        }
        ArrayList<Version> list = new ArrayList<Version>(versions);
        list.sort(Comparator.reverseOrder());
        return list;
    }

    private void setMergedVersionsProperty(List<Version> versions) {
        String mergeFromVersions = versions.stream().map(Version::getName).collect(Collectors.joining(","));
        this.versionPropertiesMap.put("ucd.version.mergefromversions", mergeFromVersions);
    }

    private void downloadVersionsToBeMerged(List<Version> versions, MergeVersionsInput pluginInputs) throws Exception {
        ExtRepoVersionDownloader extRepoVersionDownloader = new ExtRepoVersionDownloader(pluginInputs);
        for (Version version : versions) {
            File versionDir = this.getVersionDir(version.getName());
            String downloadZipFilePath = versionDir.getCanonicalPath() + File.separator + PACKAGE_VERSION_ZIP;
            if (!versionDir.mkdirs()) {
                throw new RuntimeException("Failed to create version directory " + versionDir.getCanonicalPath());
            }
            String url = pluginInputs.isAtTlsEnabled() ? version.getDownloadUrl().replace(HTTPS, HTTP) : version.getDownloadUrl();
            extRepoVersionDownloader.download(url, downloadZipFilePath);
            ZipExtractor.extract(downloadZipFilePath, versionDir.getCanonicalPath());
        }
    }

    private String getMergedVersionType(List<Version> versions) {
        boolean containsFullVersion = versions.stream().anyMatch(version -> version.getType().equalsIgnoreCase(VERSION_TYPE_FULL));
        return containsFullVersion ? VERSION_TYPE_FULL : VERSION_TYPE_INCREMENTAL;
    }

    private void uploadVersionArtifactsToExternalRepository(MergeVersionsInput pluginInputs, UUID versionId) throws IOException {
        String versionZipPath = this.createArtifactsZipForExternalRepository(pluginInputs.getMergedVersion());
        ExternalRepoUploader externalRepoUploader = new ExternalRepoUploader(pluginInputs, versionZipPath);
        try {
            externalRepoUploader.upload();
        }
        catch (Exception exception) {
            if (externalRepoUploader.getResponseBody() != null) {
                System.out.println(externalRepoUploader.getResponseBody());
            }
            this.versionClientUtil.deleteVersion(versionId);
            throw exception;
        }
        this.versionPropertiesMap.put(EXT_REPO_URL_VERSION_PROPERTY_NAME, externalRepoUploader.getUrlToDownloadZip());
    }

    private void createMergedVersionDirectory(String mergedVersion) throws IOException {
        File mergedVersionDir = new File(this.workDir, mergedVersion);
        if (!mergedVersionDir.mkdirs()) {
            throw new RuntimeException("Failed to create merged version directory " + mergedVersionDir.getCanonicalPath());
        }
    }

    private void createMergedPackageManifestXml(List<Version> versions, String mergedVersion) throws IOException, XMLStreamException {
        Version firstVersion = versions.get(0);
        String firstVersionPackageManifestPath = this.getVersionPackageManifestPath(firstVersion.getName());
        PackageManifest mergedPackageManifest = PackageManifest.from((String)firstVersionPackageManifestPath);
        for (int i = 1; i < versions.size(); ++i) {
            Version version = versions.get(i);
            String versionPackageManifestPath = this.getVersionPackageManifestPath(version.getName());
            PackageManifest packageManifest = PackageManifest.from((String)versionPackageManifestPath);
            if (!packageManifest.getVersion().equalsIgnoreCase(mergedPackageManifest.getVersion())) {
                throw new IllegalArgumentException("Merging versions with different package formats is not supported.");
            }
            mergedPackageManifest.merge(packageManifest);
            FileUtil.writeStringToFile(packageManifest.getXml(), versionPackageManifestPath);
        }
        this.isNewPackageFormat = mergedPackageManifest.isNewPackageFormat();
        String mergedPackageManifestXml = mergedPackageManifest.getXml();
        String mergedPackageManifestPath = this.getVersionPackageManifestPath(mergedVersion);
        System.out.println(" [Info] Creating packageManifest XML - " + mergedPackageManifestPath);
        FileUtil.writeStringToFile(mergedPackageManifestXml, mergedPackageManifestPath);
        String packageManifestInUTF8 = mergedPackageManifestXml.replace("encoding=\"IBM-1047\"", "");
        String mergedPackageManifestPathInUTF8 = this.getVersionPackageManifestPath(mergedVersion) + UTF_8_EXTENSION;
        FileUtil.writeStringToFile(packageManifestInUTF8, mergedPackageManifestPathInUTF8, StandardCharsets.UTF_8);
    }

    private void createMergedPackageZip(List<Version> versions, MergeVersionsInput pluginInputs) throws IOException {
        if (this.isNewPackageFormat) {
            new PackageZipMerger(this.workDir).merge(versions, pluginInputs.getMergedVersion());
        } else {
            List<String> versionFilesToBeMerged = this.moveFilesToMergedVersionDirectory(versions, pluginInputs.getMergedVersion());
            String packageZipPath = this.getVersionPackageZipFilePath(pluginInputs.getMergedVersion());
            System.out.println(" [Info] Creating package zip file " + packageZipPath);
            ZipCompressor.compress(packageZipPath, versionFilesToBeMerged);
        }
    }

    private List<String> moveFilesToMergedVersionDirectory(List<Version> versions, String mergedVersion) throws IOException {
        ArrayList<String> versionsFilesToBeMerged = new ArrayList<String>();
        File mergedVersionDir = this.getVersionDir(mergedVersion);
        for (Version version : versions) {
            String packageZipFilePath = this.getVersionPackageZipFilePath(version.getName());
            if (FileHelper.isFileExist((String)packageZipFilePath)) {
                String mergedVersionPackageZipFilePath = mergedVersionDir.getCanonicalPath() + File.separator + PACKAGE_PREFIX + version.getId() + ZIP_EXTENSION;
                FileHelper.renameFile((String)packageZipFilePath, (String)mergedVersionPackageZipFilePath);
                versionsFilesToBeMerged.add(mergedVersionPackageZipFilePath);
            }
            String mergedVersionPackageManifestXmlFilePath = mergedVersionDir.getCanonicalPath() + File.separator + PACKAGE_MANIFEST_PREFIX + version.getId() + XML_EXTENSION;
            String versionPackageManifestPath = this.getVersionPackageManifestPath(version.getName());
            FileHelper.renameFile((String)versionPackageManifestPath, (String)mergedVersionPackageManifestXmlFilePath);
            versionsFilesToBeMerged.add(mergedVersionPackageManifestXmlFilePath);
        }
        return versionsFilesToBeMerged;
    }

    private String createArtifactsZipForExternalRepository(String mergedVersion) throws IOException {
        ArrayList<String> versionFiles = new ArrayList<String>();
        versionFiles.add(this.getVersionPackageManifestPath(mergedVersion));
        String versionPackageZipFilePath = this.getVersionPackageZipFilePath(mergedVersion);
        if (FileHelper.isFileExist((String)versionPackageZipFilePath)) {
            versionFiles.add(versionPackageZipFilePath);
        }
        String versionZipPath = this.getVersionDir(mergedVersion).getCanonicalPath() + File.separator + mergedVersion + ZIP_EXTENSION;
        try (FileOutputStream fileOutputStream = new FileOutputStream(versionZipPath);
             ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);){
            for (String versionFile : versionFiles) {
                this.addFileToZip(versionFile, zipOutputStream);
            }
        }
        return versionZipPath;
    }

    private void addFileToZip(String versionFilePath, ZipOutputStream zipOutputStream) throws IOException {
        File versionFile = new File(versionFilePath);
        try (FileInputStream fis = new FileInputStream(versionFile);){
            int length;
            ZipEntry zipEntry = new ZipEntry(versionFile.getName());
            zipOutputStream.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOutputStream.write(bytes, 0, length);
            }
            zipOutputStream.closeEntry();
        }
    }

    private String getVersionPackageZipFilePath(String versionName) throws IOException {
        return this.getVersionDir(versionName).getCanonicalPath() + File.separator + PACKAGE_ZIP;
    }

    private String getVersionPackageManifestPath(String versionName) throws IOException {
        return this.getVersionDir(versionName).getCanonicalPath() + File.separator + PACKAGE_MANIFEST_XML;
    }

    private File getVersionDir(String versionName) {
        return new File(this.workDir, versionName);
    }
}

