/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.merge.common;

import com.urbancode.air.plugin.command.merge.common.Version;
import com.urbancode.commons.util.IO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;

public class PackageZipMerger {
    private static final String PACKAGE_ZIP = "package.zip";
    private final File workDir;

    public PackageZipMerger(File workDir) {
        this.workDir = workDir;
    }

    public void merge(List<Version> versions, String mergedVersion) throws IOException {
        Path mergedVersionPackageZipPath = Paths.get(this.getVersionPackageZipFilePath(mergedVersion), new String[0]);
        try (TarArchiveOutputStream taos = new TarArchiveOutputStream(Files.newOutputStream(mergedVersionPackageZipPath, new OpenOption[0]));){
            this.mergePackageZipFiles(versions, taos);
        }
    }

    private void mergePackageZipFiles(List<Version> versions, TarArchiveOutputStream taos) throws IOException {
        HashSet<String> pathsSeen = new HashSet<String>();
        for (Version ver : versions) {
            Path versionPackageZipPath = Paths.get(this.getVersionPackageZipFilePath(ver.getName()), new String[0]);
            if (!versionPackageZipPath.toFile().exists()) continue;
            TarArchiveInputStream tais = new TarArchiveInputStream(Files.newInputStream(versionPackageZipPath, new OpenOption[0]));
            Throwable throwable = null;
            try {
                TarArchiveEntry tae = tais.getNextEntry();
                while (tae != null) {
                    String path = tae.getName();
                    if (pathsSeen.add(path)) {
                        taos.putArchiveEntry(tae);
                        IO.copy((InputStream)tais, (OutputStream)taos);
                        taos.closeArchiveEntry();
                    }
                    tae = tais.getNextEntry();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (tais == null) continue;
                if (throwable != null) {
                    try {
                        tais.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                tais.close();
            }
        }
    }

    private String getVersionPackageZipFilePath(String versionName) throws IOException {
        return this.getVersionDir(versionName).getCanonicalPath() + File.separator + PACKAGE_ZIP;
    }

    private File getVersionDir(String versionName) {
        return new File(this.workDir, versionName);
    }
}

