/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.merge.common;

import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;

public class Version
implements Comparable<Version> {
    private static final String VERSION_CREATED_DATE = "created";
    private static final String VERSION_TYPE = "type";
    private static final String PROPERTIES = "properties";
    private static final String EXT_REPO_URL = "extRepoURL";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_VALUE = "value";
    private final String name;
    private final String id;
    private final Long createdDate;
    private final String type;
    private final String downloadUrl;

    public Version(String name, String id, JSONObject jsonObject) throws JSONException {
        this.name = name;
        this.id = id;
        this.type = jsonObject.get(VERSION_TYPE).toString();
        this.createdDate = (Long)jsonObject.get(VERSION_CREATED_DATE);
        this.downloadUrl = this.getDownloadUrl(jsonObject);
    }

    private String getDownloadUrl(JSONObject jsonObject) throws JSONException {
        JSONArray versionProperties = (JSONArray)jsonObject.get(PROPERTIES);
        for (int i = 0; i < versionProperties.length(); ++i) {
            JSONObject property = (JSONObject)versionProperties.get(i);
            if (!property.get(PROPERTY_NAME).toString().equals(EXT_REPO_URL)) continue;
            return property.get(PROPERTY_VALUE).toString();
        }
        throw new IllegalArgumentException("Version property extRepoURL not found for version " + this.name);
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Long getCreatedDate() {
        return this.createdDate;
    }

    public String getType() {
        return this.type;
    }

    @Override
    public int compareTo(Version other) {
        return this.createdDate.compareTo(other.getCreatedDate());
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }
}

