/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.urbancode.zos.linked.version;

import com.ibm.urbancode.zos.helpers.FileHelper;
import com.ibm.urbancode.zos.linked.version.LinkedVersionInputs;
import java.io.File;
import java.io.IOException;
import java.util.Optional;

public class LinkedVersionUtil {
    private static final String DEPLOY_DIR = "deploy";
    private static final String FROM_VERSION_ID_TXT_FILE = "fromVersionId.txt";
    private final LinkedVersionInputs pluginInputs;

    LinkedVersionUtil(LinkedVersionInputs pluginInputs) {
        this.pluginInputs = pluginInputs;
    }

    public static String resolveAndCacheFromVersionId(LinkedVersionInputs pluginInputs) throws IOException {
        LinkedVersionUtil linkedVersionUtil = new LinkedVersionUtil(pluginInputs);
        String resolvedVersionId = linkedVersionUtil.resolveFromVersionId();
        linkedVersionUtil.cacheFromVersionIdIfNeeded(resolvedVersionId);
        return resolvedVersionId;
    }

    private String resolveFromVersionId() throws IOException {
        Optional<String> cachedVersionId = this.readCachedFromVersionId();
        String providedFromVersionId = this.pluginInputs.getFromVersionId();
        if (providedFromVersionId.isEmpty()) {
            if (cachedVersionId.isPresent()) {
                System.out.println(" [Info] No 'From Version ID' provided, using cached 'From Version ID': " + cachedVersionId.get());
                return cachedVersionId.get();
            }
            System.out.println(" [Info] No 'From Version ID' provided and no cached 'From Version ID' found.");
            return providedFromVersionId;
        }
        if (this.pluginInputs.getVersionId().equals(providedFromVersionId)) {
            if (cachedVersionId.isPresent()) {
                System.out.println(" [Info] Using cached 'From Version ID': " + cachedVersionId.get());
                return cachedVersionId.get();
            }
            System.out.println(" [Info] No cached 'From Version ID' found, using provided 'From Version ID': " + providedFromVersionId);
        } else {
            System.out.println(" [Info] Using provided 'From Version ID': " + providedFromVersionId);
        }
        return providedFromVersionId;
    }

    private void cacheFromVersionIdIfNeeded(String resolvedFromVersionId) throws IOException {
        if (!this.pluginInputs.getVersionId().equals(this.pluginInputs.getFromVersionId())) {
            this.cacheFromVersionId(resolvedFromVersionId);
        }
    }

    Optional<String> readCachedFromVersionId() throws IOException {
        String deployVersionDirPath = this.getDeployVersionDirPath();
        String cachedFromVersionIdFilePath = deployVersionDirPath + File.separator + FROM_VERSION_ID_TXT_FILE;
        File cachedFromVersionIdFile = new File(cachedFromVersionIdFilePath);
        if (cachedFromVersionIdFile.exists()) {
            String cachedFromVersionId = FileHelper.getFileContent(cachedFromVersionIdFilePath).trim();
            return Optional.of(cachedFromVersionId);
        }
        return Optional.empty();
    }

    private void cacheFromVersionId(String fromVersionId) throws IOException {
        String deployVersionDirPath = this.getDeployVersionDirPath();
        if (!new File(deployVersionDirPath).exists()) {
            System.out.println(" [Info] Creating deploy version directory - " + deployVersionDirPath);
            FileHelper.createDir(deployVersionDirPath);
        }
        String cachedFromVersionIdFilePath = deployVersionDirPath + File.separator + FROM_VERSION_ID_TXT_FILE;
        System.out.println(" [Info] Caching 'From Version ID' to file - " + cachedFromVersionIdFilePath);
        FileHelper.writeStringToFile(fromVersionId, cachedFromVersionIdFilePath);
    }

    private String getDeployVersionDirPath() {
        return this.pluginInputs.getDeployBasePath() + File.separator + DEPLOY_DIR + File.separator + this.pluginInputs.getResourceId() + File.separator + this.pluginInputs.getComponentName() + File.separator + this.pluginInputs.getVersionName();
    }
}

