/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.download.ExtRepoDownloadInputs;
import com.urbancode.air.plugin.command.download.UrlFilePath;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class ExtRepoFilesDownloader {
    private static final int BYTE_SIZE = 0x200000;

    private ExtRepoFilesDownloader() {
    }

    public static void downloadFile(ExtRepoDownloadInputs pluginInputs, String filePath) throws IOException {
        HttpClientBuilder2 clientBuilder = ExtRepoFilesDownloader.getInitializedBuilder(pluginInputs);
        try (CloseableHttpClient client = clientBuilder.buildClient();){
            ExtRepoFilesDownloader.downloadFile(client, pluginInputs.getExtRepoURL(), filePath);
        }
    }

    public static void downloadFiles(ExtRepoDownloadInputs pluginInputs, List<UrlFilePath> urlFilePaths, String versionDir) throws IOException {
        HttpClientBuilder2 clientBuilder = ExtRepoFilesDownloader.getInitializedBuilder(pluginInputs);
        try (CloseableHttpClient client = clientBuilder.buildClient();){
            urlFilePaths.parallelStream().forEach(urlFilePath -> {
                String filePath = versionDir + File.separator + urlFilePath.getFilePath();
                String externalRepoFileUrl = pluginInputs.getExtRepoURL() + File.separator + urlFilePath.getUrlPath();
                ExtRepoFilesDownloader.downloadFile(client, externalRepoFileUrl, filePath);
            });
        }
    }

    private static HttpClientBuilder2 getInitializedBuilder(ExtRepoDownloadInputs pluginInputs) {
        HttpClientBuilder2 builder = new HttpClientBuilder2();
        builder.setPreemptiveAuthentication(true);
        if (!pluginInputs.getUsername().isEmpty()) {
            builder.setUsername(pluginInputs.getUsername());
            String password = pluginInputs.getApiKey().isEmpty() ? pluginInputs.getPassword() : pluginInputs.getApiKey();
            builder.setPassword(password);
        }
        if (!pluginInputs.getHttpProxyHost().isEmpty()) {
            System.out.println(" [Info] Using Proxy Host " + pluginInputs.getHttpProxyHost());
            builder.setProxyHost(pluginInputs.getHttpProxyHost());
        }
        if (!pluginInputs.getHttpProxyPort().isEmpty()) {
            System.out.println(" [Info] Using Proxy Port " + pluginInputs.getHttpProxyPort());
            builder.setProxyPort(Integer.parseInt(pluginInputs.getHttpProxyPort()));
        }
        if (pluginInputs.isInsecureConnectionAllowed()) {
            System.out.println("[Info] Allowing insecure connections. Review with your security admins before allowing insecure connections...");
            builder.setTrustAllCerts(true);
        }
        return builder;
    }

    private static HttpResponse getOkResponse(CloseableHttpClient client, String url) throws IOException {
        HttpGet get = new HttpGet(url);
        get.addHeader("accept", "application/octet-stream");
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("HTTP response error code =" + response.getStatusLine().getStatusCode() + "\nResponse=" + response.toString().replace("\n", ""));
        }
        return response;
    }

    private static void downloadFile(CloseableHttpClient client, String externalRepoUrl, String filePath) {
        try {
            System.out.println(" [Info] Downloading - " + externalRepoUrl);
            HttpResponse response = ExtRepoFilesDownloader.getOkResponse(client, externalRepoUrl);
            File file = new File(filePath);
            ExtRepoFilesDownloader.createFileDirectory(file);
            try (InputStream inputStream = response.getEntity().getContent();){
                ExtRepoFilesDownloader.writeToFile(inputStream, file);
            }
        }
        catch (IOException ioException) {
            throw new RuntimeException("File download failed - " + ioException.getMessage());
        }
    }

    private static void createFileDirectory(File file) throws IOException {
        File fileDir = file.getParentFile();
        Files.createDirectories(fileDir.toPath(), new FileAttribute[0]);
    }

    private static void writeToFile(InputStream inputStream, File file) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int read;
            byte[] buffer = new byte[0x200000];
            while ((read = inputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, read);
            }
        }
    }
}

