/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command.merge.common;

import com.urbancode.air.plugin.command.merge.common.MergeVersionsInput;
import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

class ExtRepoVersionDownloader {
    private static final int BYTE_SIZE = 0x200000;
    private final HttpClientBuilder2 builder;

    public ExtRepoVersionDownloader(MergeVersionsInput pluginInputs) {
        this.builder = pluginInputs.getHttpClientBuilder();
    }

    public void download(String versionZipUrl, String downloadZipFilePath) throws IOException {
        try (CloseableHttpClient client = this.builder.buildClient();){
            this.downloadZipFromExternalRepo(client, versionZipUrl, downloadZipFilePath);
        }
    }

    private void downloadZipFromExternalRepo(CloseableHttpClient client, String externalRepoUrl, String downloadZipFilePath) throws IOException {
        System.out.println(" [Info] Attempting to download version from external repository...");
        HttpResponse response = this.getOkResponse(client, externalRepoUrl);
        File downloadZipFile = new File(downloadZipFilePath);
        downloadZipFile.deleteOnExit();
        try (InputStream inputStream = response.getEntity().getContent();){
            this.writeToZipFile(inputStream, downloadZipFile);
        }
        System.out.println(" [Info] Downloaded compressed version file from external repository to " + downloadZipFilePath);
    }

    private HttpResponse getOkResponse(CloseableHttpClient client, String url) throws IOException {
        HttpGet get = new HttpGet(url);
        get.addHeader("accept", "application/octet-stream");
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("HTTP response error code =" + response.getStatusLine().getStatusCode() + "\nResponse=" + response.toString().replace("\n", ""));
        }
        System.out.println(" [Info] HTTP response is success");
        return response;
    }

    private void writeToZipFile(InputStream inputStream, File downloadZipFile) throws IOException {
        try (FileOutputStream fileOutputStream = new FileOutputStream(downloadZipFile);){
            int read;
            byte[] buffer = new byte[0x200000];
            while ((read = inputStream.read(buffer)) > 0) {
                fileOutputStream.write(buffer, 0, read);
            }
        }
    }
}

