/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.ExtRepoHelper;
import com.urbancode.airplugins.AirPluginTool;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ExtRepoDownload {
    private static final String ENCODING_CP037 = "CP037";
    private static final String IBM_1047 = "IBM-1047";
    private static final int BYTE_SIZE = 0x100000;
    private static final String MANIFEST_NODE = "manifest";
    private static final String MANIFEST_VERSION_ATTRIBUTE = "version";
    private static final int ERR_CODE = 8;
    private static final String PACKAGE_ZIP = "package.zip";
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";

    public static void main(String[] args) {
        try {
            File versionDirectory;
            String extRepoPassword;
            AirPluginTool apTool = new AirPluginTool(args[0], args[1]);
            Properties inputProperties = apTool.getStepProperties();
            String extRepoURL = inputProperties.getProperty("extRepoURL");
            String username = inputProperties.getProperty("username");
            String password = inputProperties.getProperty("password");
            String apiKey = inputProperties.getProperty("apiKey");
            boolean apiKeyCheckBox = Boolean.parseBoolean(inputProperties.getProperty("apiKeyCheckBox"));
            boolean proxyCheckBox = Boolean.parseBoolean(inputProperties.getProperty("proxyCheckBox"));
            String versionName = inputProperties.getProperty("versionName");
            String resourceId = inputProperties.getProperty("resourceId");
            boolean allowInsecure = Boolean.parseBoolean(inputProperties.getProperty("allowInsecure"));
            String osName = System.getProperty("os.name").toLowerCase(Locale.US);
            String httpProxyHost = inputProperties.getProperty("httpProxyHost");
            String httpProxyPort = inputProperties.getProperty("httpProxyPort");
            String useAtTls = inputProperties.getProperty("USE_ATTLS");
            if (ExtRepoDownload.isNullOrEmpty(extRepoURL)) {
                throw new IllegalArgumentException(" [Error] External Repository URL is null or empty");
            }
            if (ExtRepoDownload.isNullOrEmpty(username)) {
                throw new IllegalArgumentException(" [Error] User name for external repository is null or empty");
            }
            if (apiKeyCheckBox && !ExtRepoDownload.isNullOrEmpty(apiKey)) {
                extRepoPassword = apiKey;
            } else if (!ExtRepoDownload.isNullOrEmpty(password)) {
                extRepoPassword = password;
            } else {
                throw new IllegalArgumentException(" [Error] Either Password or API key should be passed for external repository");
            }
            if (ExtRepoDownload.isNullOrEmpty(versionName)) {
                throw new IllegalArgumentException(" [Error] Version Name is null or empty");
            }
            if (ExtRepoDownload.isNullOrEmpty(resourceId)) {
                throw new IllegalArgumentException(" [Error] Resource Id is null or empty");
            }
            if (ExtRepoDownload.isNullOrEmpty(useAtTls)) {
                throw new IllegalArgumentException(" [Error] AT_TLS is null or empty; set to TRUE or FALSE");
            }
            if (proxyCheckBox) {
                if (!ExtRepoDownload.isNullOrEmpty(httpProxyHost)) {
                    System.out.println(" [Info] Using Proxy Host " + httpProxyHost);
                    if (!ExtRepoDownload.isNullOrEmpty(httpProxyPort)) {
                        System.out.println(" [Info] Using Proxy Port " + httpProxyPort);
                    }
                } else {
                    throw new IllegalArgumentException(" [Error] Http Proxy Host is null or empty");
                }
            }
            if ((versionDirectory = new File("." + File.separator + resourceId + File.separator + versionName).getCanonicalFile()).exists()) {
                if (!versionDirectory.isDirectory()) {
                    throw new IllegalArgumentException(" [Error] " + versionDirectory + " is not a directory.");
                }
                if (!versionDirectory.canWrite()) {
                    throw new IllegalArgumentException(" [Error] User doesn't have WRITE permission to directory " + versionDirectory.getCanonicalPath());
                }
                System.out.println(" [Info] Deleting work directory - " + versionDirectory);
                if (!ExtRepoDownload.deleteDirectory(versionDirectory)) {
                    throw new IllegalArgumentException(" [Error] Failed to delete directory " + versionDirectory);
                }
            }
            if (!versionDirectory.mkdirs()) {
                throw new IllegalArgumentException(" [Error] Failed to create version directory " + versionDirectory);
            }
            ExtRepoHelper extRepoHelper = new ExtRepoHelper(username, extRepoPassword, httpProxyHost, httpProxyPort, allowInsecure);
            extRepoHelper.createClient();
            if (Boolean.parseBoolean(useAtTls)) {
                extRepoURL = extRepoURL.replace("https", "http");
            }
            File downloadedZipFile = extRepoHelper.downloadZOSZip(extRepoURL, versionDirectory);
            downloadedZipFile.deleteOnExit();
            String destDirectory = versionDirectory.getCanonicalPath();
            ExtRepoDownload.unzip(downloadedZipFile.getCanonicalPath(), destDirectory);
            File pkgManifestFile = new File(destDirectory + File.separator + PACKAGE_MANIFEST_XML);
            if (!pkgManifestFile.exists()) {
                throw new IllegalArgumentException(" [Error] packageManifest.xml not found in external repository");
            }
            System.out.println(" [Info] Extracted version files from the downloaded zip file");
            String packageZipFilePath = destDirectory + File.separator + PACKAGE_ZIP;
            File packageZipFile = new File(packageZipFilePath);
            if (packageZipFile.exists() && ExtRepoDownload.isSecondVersion(pkgManifestFile.getCanonicalPath())) {
                if (osName.equalsIgnoreCase("z/OS")) {
                    ExtRepoDownload.extractPax(packageZipFilePath, new File(destDirectory));
                    if (!packageZipFile.renameTo(new File(destDirectory + "/processed_" + PACKAGE_ZIP))) {
                        throw new IllegalArgumentException(" [Error] Failed to rename package zip file");
                    }
                    System.out.println(" [Info] Deployment package extracted successfully to " + destDirectory);
                } else {
                    System.out.println(" [Info] Downloaded package.zip and packageManifest.xml to the directory " + destDirectory);
                }
            }
            System.exit(0);
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(8);
    }

    private static void unzip(String zipFilePath, String destDirectory) throws IOException {
        try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(zipFilePath));){
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                String filePath = destDirectory + File.separator + entry.getName();
                if (!entry.isDirectory()) {
                    ExtRepoDownload.extractFile(zipInputStream, filePath);
                } else {
                    File dir = new File(filePath);
                    if (!dir.mkdir()) {
                        throw new IllegalArgumentException(" [Error] Failed to create directory " + dir.getCanonicalPath());
                    }
                }
                zipInputStream.closeEntry();
                entry = zipInputStream.getNextEntry();
            }
        }
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(filePath));){
            int read;
            byte[] bytesIn = new byte[0x100000];
            while ((read = zipIn.read(bytesIn)) != -1) {
                bufferedOutputStream.write(bytesIn, 0, read);
            }
        }
        System.out.println(" [unzip] " + filePath);
    }

    private static void extractPax(String zipFilePath, File workDir) throws Exception {
        String line;
        String[] cmdArgs = new String[]{"pax", "-r", "-f", zipFilePath};
        ProcessBuilder pb = new ProcessBuilder(cmdArgs).directory(workDir);
        Process process = pb.start();
        try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream(), IBM_1047));){
            while ((line = stdInput.readLine()) != null) {
                System.out.println(line);
            }
        }
        var7_6 = null;
        try (BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream(), IBM_1047));){
            while ((line = stdError.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        process.waitFor();
        if (process.exitValue() > 0) {
            throw new IllegalArgumentException(" [Error] pax command failed with exit code - " + process.exitValue());
        }
    }

    private static boolean isSecondVersion(String manifestPath) throws XMLStreamException, IOException {
        boolean isNewPackage = false;
        try (FileInputStream shipListFileStream = new FileInputStream(manifestPath);){
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            XMLEventReader shiplistEventReader = inputFactory.createXMLEventReader(shipListFileStream, ENCODING_CP037);
            while (shiplistEventReader.hasNext()) {
                StartElement startElement;
                String nodeName;
                XMLEvent shipListReaderEvent = shiplistEventReader.nextEvent();
                if (shipListReaderEvent.getEventType() != 1 || !MANIFEST_NODE.equalsIgnoreCase(nodeName = (startElement = shipListReaderEvent.asStartElement()).getName().getLocalPart().trim())) continue;
                String versionValue = ExtRepoDownload.getAttributeValue(startElement);
                isNewPackage = versionValue != null && versionValue.equals("v2_0");
                break;
            }
        }
        return isNewPackage;
    }

    private static String getAttributeValue(StartElement startElement) {
        if (null == startElement) {
            return null;
        }
        Iterator<Attribute> it = startElement.getAttributes();
        while (it.hasNext()) {
            String value;
            Attribute attr = it.next();
            if (!attr.getName().getLocalPart().trim().equalsIgnoreCase(MANIFEST_VERSION_ATTRIBUTE) || null == (value = attr.getValue())) continue;
            return value.trim();
        }
        return null;
    }

    private static boolean deleteDirectory(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        return ExtRepoDownload.deleteDir0(file);
    }

    private static boolean deleteDir0(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                ExtRepoDownload.deleteDir0(f);
            }
        }
        return file.delete();
    }

    private static boolean isNullOrEmpty(String str) {
        return str == null || str.trim().isEmpty();
    }
}

