/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.ExtRepoDownloadInputs;
import com.urbancode.air.plugin.command.ExtRepoHelper;
import com.urbancode.air.plugin.command.FileHelper;
import com.urbancode.air.plugin.command.MissingInputException;
import com.urbancode.air.plugin.command.PackageVersion;
import com.urbancode.air.plugin.command.PaxExtractor;
import com.urbancode.air.plugin.command.ZipExtractor;
import java.io.File;
import java.util.Locale;
import java.util.Properties;

public class ExtRepoDownload {
    private static final int ERR_CODE = 8;
    private static final String PACKAGE_ZIP = "package.zip";
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private final Properties inputProperties;

    public ExtRepoDownload(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() {
        try {
            File versionDirectory;
            String extRepoPassword;
            ExtRepoDownloadInputs pluginInputs = ExtRepoDownloadInputs.getValidatedInputs(this.inputProperties);
            String osName = System.getProperty("os.name").toLowerCase(Locale.US);
            String string = extRepoPassword = pluginInputs.isApiKeyPassed() ? pluginInputs.getApiKey() : pluginInputs.getPassword();
            if (pluginInputs.isProxyEnabled()) {
                if (!pluginInputs.getHttpProxyHost().isEmpty()) {
                    System.out.println(" [Info] Using Proxy Host " + pluginInputs.getHttpProxyHost());
                    if (!pluginInputs.getHttpProxyPort().isEmpty()) {
                        System.out.println(" [Info] Using Proxy Port " + pluginInputs.getHttpProxyPort());
                    }
                } else {
                    throw new MissingInputException("Proxy is enabled but Http Proxy Host is empty");
                }
            }
            if ((versionDirectory = new File("." + File.separator + pluginInputs.getResourceId() + File.separator + pluginInputs.getVersionName()).getCanonicalFile()).exists()) {
                if (!versionDirectory.isDirectory()) {
                    throw new IllegalArgumentException(versionDirectory + " is not a directory.");
                }
                if (!versionDirectory.canWrite()) {
                    throw new IllegalArgumentException("User doesn't have WRITE permission to directory " + versionDirectory.getCanonicalPath());
                }
                System.out.println(" [Info] Deleting work directory - " + versionDirectory);
                if (!FileHelper.deleteDirectory(versionDirectory)) {
                    throw new IllegalArgumentException("Failed to delete directory " + versionDirectory);
                }
            }
            FileHelper.createDirectory(versionDirectory);
            ExtRepoHelper extRepoHelper = new ExtRepoHelper(pluginInputs.getUsername(), extRepoPassword, pluginInputs.getHttpProxyHost(), pluginInputs.getHttpProxyPort(), pluginInputs.isInsecureConnectionAllowed());
            extRepoHelper.createClient();
            File downloadedZipFile = extRepoHelper.downloadZOSZip(pluginInputs.getExtRepoURL(), versionDirectory);
            downloadedZipFile.deleteOnExit();
            String destDirectory = versionDirectory.getCanonicalPath();
            ZipExtractor.extract(downloadedZipFile.getCanonicalPath(), destDirectory);
            File pkgManifestFile = new File(destDirectory + File.separator + PACKAGE_MANIFEST_XML);
            if (!pkgManifestFile.exists()) {
                throw new IllegalArgumentException("packageManifest.xml not found in external repository");
            }
            System.out.println(" [Info] Extracted version files from the downloaded zip file");
            String packageZipFilePath = destDirectory + File.separator + PACKAGE_ZIP;
            File packageZipFile = new File(packageZipFilePath);
            if (packageZipFile.exists() && PackageVersion.isV2(pkgManifestFile.getCanonicalPath())) {
                if (osName.equalsIgnoreCase("z/OS")) {
                    PaxExtractor.extract(packageZipFilePath, new File(destDirectory));
                    if (!packageZipFile.renameTo(new File(destDirectory + "/processed_" + PACKAGE_ZIP))) {
                        throw new IllegalArgumentException("Failed to rename package zip file");
                    }
                    System.out.println(" [Info] Deployment package extracted successfully to " + destDirectory);
                } else {
                    System.out.println(" [Info] Downloaded package.zip and packageManifest.xml to the directory " + destDirectory);
                }
            }
            return 0;
        }
        catch (MissingInputException | IllegalArgumentException knownRuntimeException) {
            System.out.println(" [Error] " + knownRuntimeException.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 8;
    }
}

