/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.commons.httpcomponentsutil.HttpClientBuilder2;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;

public class ExtRepoHelper {
    private static CloseableHttpClient client;
    private static final int BYTE_SIZE = 0x200000;
    private static final String PACKAGE_VERSION = "packageVersion";
    private final String username;
    private final String password;
    private final String httpProxyHost;
    private final String httpProxyPort;
    private final boolean allowInsecure;

    public ExtRepoHelper(String username, String password, String httpProxyHost, String httpProxyPort, boolean allowInsecure) {
        this.username = username;
        this.password = password;
        this.httpProxyHost = httpProxyHost;
        this.httpProxyPort = httpProxyPort;
        this.allowInsecure = allowInsecure;
    }

    public void createClient() {
        HttpClientBuilder2 builder = new HttpClientBuilder2();
        builder.setPreemptiveAuthentication(true);
        builder.setUsername(this.username);
        builder.setPassword(this.password);
        if (!this.httpProxyHost.isEmpty()) {
            builder.setProxyHost(this.httpProxyHost);
        }
        if (!this.httpProxyPort.isEmpty()) {
            int httpProxyPortNumber = Integer.parseInt(this.httpProxyPort);
            builder.setProxyPort(httpProxyPortNumber);
        }
        if (this.allowInsecure) {
            System.out.println("[Info] Allowing insecure connections. Review with your security admins before allowing insecure connections...");
            builder.setTrustAllCerts(true);
        }
        client = builder.buildClient();
    }

    private HttpResponse getOkResponse(String url) throws IOException {
        HttpGet get = new HttpGet(url);
        get.addHeader("accept", "application/json");
        CloseableHttpResponse response = client.execute((HttpUriRequest)get);
        if (response.getStatusLine().getStatusCode() != 200) {
            System.out.println("HTTP response error code =" + response.getStatusLine().getStatusCode());
            throw new IOException("Bad request status code" + response.getStatusLine().getStatusCode() + response.toString().replace("\n", ""));
        }
        System.out.println(" [Info] HTTP response is success");
        return response;
    }

    public File downloadZOSZip(String url, File versionDirectory) throws IOException {
        File tempVersionZipFile;
        System.out.println(" [Info] Attempting to download version from external repository...");
        HttpResponse response = this.getOkResponse(url);
        try (InputStream inputStream = response.getEntity().getContent();){
            tempVersionZipFile = new File(versionDirectory, "packageVersion.zip");
            try (FileOutputStream fileOutputStream = new FileOutputStream(tempVersionZipFile);){
                int read;
                byte[] buffer = new byte[0x200000];
                while ((read = inputStream.read(buffer)) > 0) {
                    fileOutputStream.write(buffer, 0, read);
                }
            }
        }
        System.out.println(" [Info] Downloaded compressed version file from external repository to " + tempVersionZipFile.getCanonicalPath());
        return tempVersionZipFile;
    }
}

