/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import java.io.File;

public final class FileHelper {
    private FileHelper() {
    }

    public static boolean deleteDirectory(File file) {
        if (file == null) {
            return true;
        }
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return false;
        }
        return FileHelper.deleteDir0(file);
    }

    private static boolean deleteDir0(File file) {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File f : files) {
                FileHelper.deleteDir0(f);
            }
        }
        return file.delete();
    }

    public static void createDirectory(String dir) {
        FileHelper.createDirectory(new File(dir));
    }

    public static void createDirectory(File dir) {
        if (!dir.mkdirs()) {
            throw new IllegalArgumentException("Failed to create directory " + dir);
        }
    }
}

