/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class PackageVersion {
    private static final String MANIFEST_VERSION_2 = "v2_0";
    private static final String MANIFEST_NODE = "manifest";
    private static final String MANIFEST_VERSION_ATTRIBUTE = "version";

    private PackageVersion() {
    }

    public static boolean isV2(String manifestPath) throws XMLStreamException, IOException {
        try (InputStream inputStream = Files.newInputStream(Paths.get(manifestPath, new String[0]), new OpenOption[0]);){
            String manifestVersion = PackageVersion.getManifestVersion(inputStream);
            boolean bl = manifestVersion != null && manifestVersion.equals(MANIFEST_VERSION_2);
            return bl;
        }
    }

    private static String getManifestVersion(InputStream inputStream) throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newFactory();
        XMLStreamReader xmlStreamReader = inputFactory.createXMLStreamReader(inputStream, PackageVersion.getFileEncoding());
        while (xmlStreamReader.hasNext()) {
            String tagName;
            if (xmlStreamReader.next() != 1 || !(tagName = xmlStreamReader.getLocalName().trim()).equalsIgnoreCase(MANIFEST_NODE)) continue;
            return PackageVersion.getManifestVersionAttributeValue(xmlStreamReader);
        }
        return null;
    }

    private static String getFileEncoding() {
        String fileEncoding = System.getProperty("file.encoding");
        if (fileEncoding == null) {
            throw new RuntimeException("File encoding not found under system properties.");
        }
        return fileEncoding;
    }

    private static String getManifestVersionAttributeValue(XMLStreamReader xmlStreamReader) {
        String attributeValue = xmlStreamReader.getAttributeValue(null, MANIFEST_VERSION_ATTRIBUTE);
        if (attributeValue != null) {
            return attributeValue.trim();
        }
        return null;
    }
}

