/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.FileHelper;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public final class ZipExtractor {
    private static final int BYTE_SIZE = 0x100000;

    private ZipExtractor() {
    }

    public static void extract(String zipFilePath, String destDirectory) throws IOException {
        try (InputStream inputStream = Files.newInputStream(Paths.get(zipFilePath, new String[0]), new OpenOption[0]);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String entryPath = destDirectory + File.separator + entry.getName();
                if (entry.isDirectory()) {
                    FileHelper.createDirectory(entryPath);
                } else {
                    ZipExtractor.extractFile(zipInputStream, entryPath);
                }
                zipInputStream.closeEntry();
            }
        }
    }

    private static void extractFile(ZipInputStream zipInputStream, String filePath) throws IOException {
        System.out.println(" [unzip] " + filePath);
        try (OutputStream outputStream = Files.newOutputStream(Paths.get(filePath, new String[0]), new OpenOption[0]);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);){
            int read;
            byte[] bytes = new byte[0x100000];
            while ((read = zipInputStream.read(bytes)) != -1) {
                bufferedOutputStream.write(bytes, 0, read);
            }
        }
    }
}

