/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;

public final class PaxExtractor {
    private static final String IBM_1047 = "IBM-1047";

    private PaxExtractor() {
    }

    public static void extract(String packageZipFilePath, String outDir) throws Exception {
        String[] paxExtractCommandArgs = new String[]{"pax", "-r", "-f", packageZipFilePath};
        ProcessBuilder builder = new ProcessBuilder(paxExtractCommandArgs).directory(new File(outDir));
        Process process = builder.start();
        process.getOutputStream().close();
        PaxExtractor.printStream(process.getInputStream());
        PaxExtractor.printStream(process.getErrorStream());
        int exitCode = process.waitFor();
        if (exitCode > 0) {
            throw new IllegalArgumentException("pax command failed with exit code - " + exitCode);
        }
    }

    private static void printStream(InputStream inputStream) throws IOException {
        try (BufferedReader stdInput = new BufferedReader(new InputStreamReader(inputStream, IBM_1047));){
            String line;
            while ((line = stdInput.readLine()) != null) {
                System.out.println(line);
            }
        }
    }
}

