/*
 * Decompiled with CFR 0.152.
 */
package com.urbancode.air.plugin.command;

import com.urbancode.air.plugin.command.ExtRepoDownloadInputs;
import com.urbancode.air.plugin.command.ExtRepoHelper;
import com.urbancode.air.plugin.command.FileHelper;
import com.urbancode.air.plugin.command.MissingInputException;
import com.urbancode.air.plugin.command.PackageVersion;
import com.urbancode.air.plugin.command.PaxExtractor;
import com.urbancode.air.plugin.command.ZipExtractor;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class ExtRepoDownload {
    private static final int EXIT_CODE_8 = 8;
    private static final int EXIT_CODE_0 = 0;
    private static final String PACKAGE_VERSION_ZIP = "packageVersion.zip";
    private static final String PACKAGE_ZIP = "package.zip";
    private static final String PACKAGE_MANIFEST_XML = "packageManifest.xml";
    private final Properties inputProperties;

    public ExtRepoDownload(Properties inputProperties, Properties ignoredOutputProperties) {
        this.inputProperties = inputProperties;
    }

    public int execute() {
        try {
            ExtRepoDownloadInputs pluginInputs = ExtRepoDownloadInputs.getValidatedInputs(this.inputProperties);
            String versionDirPath = this.getVersionDirPath(pluginInputs);
            this.createVersionDirectory(versionDirPath);
            String packageVersionZipPath = versionDirPath + File.separator + PACKAGE_VERSION_ZIP;
            ExtRepoHelper.download(pluginInputs, packageVersionZipPath);
            ZipExtractor.extract(packageVersionZipPath, versionDirPath);
            System.out.println(" [Info] Extracted version files from the downloaded zip file");
            String packageManifestPath = versionDirPath + File.separator + PACKAGE_MANIFEST_XML;
            if (FileHelper.isFileNotExist(packageManifestPath)) {
                throw new IllegalArgumentException("packageManifest.xml not found in external repository");
            }
            String packageZipPath = versionDirPath + File.separator + PACKAGE_ZIP;
            if (FileHelper.isFileExist(packageZipPath) && PackageVersion.isV2(packageManifestPath)) {
                PaxExtractor.extract(packageZipPath, versionDirPath);
                System.out.println(" [Info] Deployment package extracted successfully to " + versionDirPath);
                String processedPackageZipPath = versionDirPath + "/processed_" + PACKAGE_ZIP;
                FileHelper.renameFile(packageZipPath, processedPackageZipPath);
            }
            return 0;
        }
        catch (MissingInputException | IllegalArgumentException knownRuntimeException) {
            System.out.println(" [Error] " + knownRuntimeException.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 8;
    }

    private String getVersionDirPath(ExtRepoDownloadInputs pluginInputs) throws IOException {
        String currentWorkDir = new File(".").getCanonicalPath();
        return currentWorkDir + File.separator + pluginInputs.getResourceId() + File.separator + pluginInputs.getVersionName();
    }

    private void createVersionDirectory(String versionDirPath) throws IOException {
        if (FileHelper.isDirectoryExist(versionDirPath)) {
            System.out.println(" [Info] Deleting existing version directory - " + versionDirPath);
            FileHelper.deleteDirectory(versionDirPath);
        }
        System.out.println(" [Info] Creating version directory - " + versionDirPath);
        FileHelper.createDirectory(versionDirPath);
    }
}

